/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ModuleExports;
import com.yworks.yguard.obf.classfile.ModuleOpens;
import com.yworks.yguard.obf.classfile.ModuleProvides;
import com.yworks.yguard.obf.classfile.ModuleRequires;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ModuleAttrInfo
extends AttrInfo {
    private int u2moduleNameIndex;
    private int u2moduleFlags;
    private int u2moduleVersionIndex;
    private ModuleRequires[] requires;
    private ModuleExports[] exports;
    private ModuleOpens[] opens;
    private int[] u2usesIndex;
    private ModuleProvides[] provides;

    ModuleAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    int getModuleNameIndex() {
        return this.u2moduleNameIndex;
    }

    void setModuleNameIndex(int idx) {
        this.u2moduleNameIndex = idx;
    }

    @Override
    protected String getAttrName() {
        return "Module";
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        if (this.u2moduleVersionIndex > 0) {
            pool.incRefCount(this.u2moduleVersionIndex);
        }
        for (int i = 0; i < this.requires.length; ++i) {
            pool.incRefCount(this.requires[i].u2requiresVersionIndex);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2moduleNameIndex = din.readUnsignedShort();
        this.u2moduleFlags = din.readUnsignedShort();
        this.u2moduleVersionIndex = din.readUnsignedShort();
        int u2requiresCount = din.readUnsignedShort();
        this.requires = new ModuleRequires[u2requiresCount];
        for (int i = 0; i < u2requiresCount; ++i) {
            this.requires[i] = ModuleRequires.read(din);
        }
        int u2exportsCount = din.readUnsignedShort();
        this.exports = new ModuleExports[u2exportsCount];
        for (int i = 0; i < u2exportsCount; ++i) {
            this.exports[i] = ModuleExports.read(din);
        }
        int u2opensCount = din.readUnsignedShort();
        this.opens = new ModuleOpens[u2opensCount];
        for (int i = 0; i < u2opensCount; ++i) {
            this.opens[i] = ModuleOpens.read(din);
        }
        int u2usesCount = din.readUnsignedShort();
        this.u2usesIndex = new int[u2usesCount];
        for (int i = 0; i < u2usesCount; ++i) {
            this.u2usesIndex[i] = din.readUnsignedShort();
        }
        int u2providesCount = din.readUnsignedShort();
        this.provides = new ModuleProvides[u2providesCount];
        for (int i = 0; i < u2providesCount; ++i) {
            this.provides[i] = ModuleProvides.read(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2moduleNameIndex);
        dout.writeShort(this.u2moduleFlags);
        dout.writeShort(this.u2moduleVersionIndex);
        int u2requiresCount = this.requires.length;
        dout.writeShort(u2requiresCount);
        for (int i = 0; i < u2requiresCount; ++i) {
            this.requires[i].write(dout);
        }
        int u2exportsCount = this.exports.length;
        dout.writeShort(u2exportsCount);
        for (int i = 0; i < u2exportsCount; ++i) {
            this.exports[i].write(dout);
        }
        int u2opensCount = this.opens.length;
        dout.writeShort(u2opensCount);
        for (int i = 0; i < u2opensCount; ++i) {
            this.opens[i].write(dout);
        }
        int u2usesCount = this.u2usesIndex.length;
        dout.writeShort(u2usesCount);
        for (int i = 0; i < u2usesCount; ++i) {
            dout.writeShort(this.u2usesIndex[i]);
        }
        int u2providesCount = this.provides.length;
        dout.writeShort(u2providesCount);
        for (int i = 0; i < u2providesCount; ++i) {
            this.provides[i].write(dout);
        }
    }
}

