/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.LocalVariableInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableTableAttrInfo
extends AttrInfo {
    private int u2localVariableTableLength;
    private LocalVariableInfo[] localVariableTable;

    protected LocalVariableTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LocalVariableTable";
    }

    protected LocalVariableInfo[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void setLocalVariableTable(LocalVariableInfo[] lvts) {
        this.localVariableTable = lvts;
        this.u2localVariableTableLength = lvts.length;
        this.u4attrLength = 2 + 10 * this.u2localVariableTableLength;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            this.localVariableTable[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2localVariableTableLength = din.readUnsignedShort();
        this.localVariableTable = new LocalVariableInfo[this.u2localVariableTableLength];
        for (int i = 0; i < this.u2localVariableTableLength; ++i) {
            this.localVariableTable[i] = LocalVariableInfo.create(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2localVariableTableLength);
        for (int i = 0; i < this.u2localVariableTableLength; ++i) {
            this.localVariableTable[i].write(dout);
        }
    }
}

