/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.obf.KeywordNameMaker;
import com.yworks.yguard.obf.NameMaker;
import com.yworks.yguard.obf.Tools;
import java.util.HashMap;
import java.util.Map;

public abstract class NameMakerFactory {
    private static NameMakerFactory instance = new DefaultNameMakerFactory();

    protected NameMakerFactory() {
    }

    public static NameMakerFactory getInstance() {
        return instance;
    }

    protected void setInstance(NameMakerFactory _instance) {
        instance = _instance;
    }

    public abstract NameMaker getPackageNameMaker(String[] var1, String var2);

    public abstract NameMaker getClassNameMaker(String[] var1, String var2);

    public abstract NameMaker getInnerClassNameMaker(String[] var1, String var2);

    public abstract NameMaker getMethodNameMaker(String[] var1, String var2);

    public abstract NameMaker getFieldNameMaker(String[] var1, String var2);

    public static class DefaultNameMakerFactory
    extends NameMakerFactory {
        private Map classNameMap = new HashMap();
        private Map fieldNameMap = new HashMap();
        private Map methodNameMap = new HashMap();
        private Map innerClassNameMap = new HashMap();
        private Map packageNameMap = new HashMap();

        @Override
        public NameMaker getClassNameMaker(String[] reservedNames, String fqClassName) {
            NameMaker res = (NameMaker)this.classNameMap.get(fqClassName);
            if (res == null) {
                res = this.createClassNameMaker(reservedNames, fqClassName);
                this.classNameMap.put(fqClassName, res);
            }
            return res;
        }

        protected NameMaker createClassNameMaker(String[] reservedNames, String fqClassName) {
            return new KeywordNameMaker(reservedNames);
        }

        @Override
        public NameMaker getFieldNameMaker(String[] reservedNames, String fqClassName) {
            NameMaker res = (NameMaker)this.fieldNameMap.get(fqClassName);
            if (res == null) {
                res = this.createFieldNameMaker(reservedNames, fqClassName);
                this.fieldNameMap.put(fqClassName, res);
            }
            return res;
        }

        protected NameMaker createFieldNameMaker(String[] reservedNames, String fqClassName) {
            return new KeywordNameMaker(reservedNames, false, true);
        }

        @Override
        public NameMaker getInnerClassNameMaker(String[] reservedNames, String fqInnerClassName) {
            NameMaker res = (NameMaker)this.innerClassNameMap.get(fqInnerClassName);
            if (res == null) {
                res = this.createInnerClassNameMaker(reservedNames, fqInnerClassName);
                this.innerClassNameMap.put(fqInnerClassName, res);
            }
            return res;
        }

        protected NameMaker createInnerClassNameMaker(final String[] reservedNames, String fqInnerClassName) {
            final KeywordNameMaker inner = new KeywordNameMaker(null);
            return new NameMaker(){

                @Override
                public String nextName(String sig) {
                    String name;
                    do {
                        name = '_' + inner.nextName(sig);
                    } while (reservedNames != null && Tools.isInArray(name, reservedNames));
                    return name;
                }
            };
        }

        @Override
        public NameMaker getMethodNameMaker(String[] reservedNames, String fqClassName) {
            NameMaker res = (NameMaker)this.methodNameMap.get(fqClassName);
            if (res == null) {
                res = this.createMethodNameMaker(reservedNames, fqClassName);
                this.methodNameMap.put(fqClassName, res);
            }
            return res;
        }

        protected NameMaker createMethodNameMaker(String[] reservedNames, String fqClassName) {
            return new KeywordNameMaker(reservedNames, false, true);
        }

        @Override
        public NameMaker getPackageNameMaker(String[] reservedNames, String packageName) {
            NameMaker res = (NameMaker)this.packageNameMap.get(packageName);
            if (res == null) {
                res = this.createPackageNameMaker(reservedNames, packageName);
                this.packageNameMap.put(packageName, res);
            }
            return res;
        }

        protected NameMaker createPackageNameMaker(String[] reservedNames, String packageName) {
            return new KeywordNameMaker(reservedNames);
        }

        public String toString() {
            return "default";
        }
    }
}

