/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.ObfuscationListener;
import com.yworks.yguard.ParseException;
import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.ClassTree;
import com.yworks.yguard.obf.Fd;
import com.yworks.yguard.obf.Filter;
import com.yworks.yguard.obf.Md;
import com.yworks.yguard.obf.ObfuscationConfig;
import com.yworks.yguard.obf.ResourceHandler;
import com.yworks.yguard.obf.Tools;
import com.yworks.yguard.obf.TreeAction;
import com.yworks.yguard.obf.TreeItem;
import com.yworks.yguard.obf.Version;
import com.yworks.yguard.obf.YGuardRule;
import com.yworks.yguard.obf.classfile.ClassConstants;
import com.yworks.yguard.obf.classfile.ClassFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class GuardDB
implements ClassConstants {
    private static final String STREAM_NAME_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_NAME_TAG = "Name";
    private static final String MANIFEST_DIGESTALG_TAG = "Digest-Algorithms";
    private static final String CLASS_EXT = ".class";
    private static final String SIGNATURE_PREFIX = "META-INF/";
    private static final String SIGNATURE_EXT = ".SF";
    private static final String LOG_MEMORY_USED = "  Memory in use after class data structure built: ";
    private static final String LOG_MEMORY_TOTAL = "  Total memory available                        : ";
    private static final String LOG_MEMORY_BYTES = " bytes";
    private static final String WARNING_SCRIPT_ENTRY_ABSENT = "<!-- WARNING - identifier from script file not found in JAR: ";
    private static final String ERROR_CORRUPT_CLASS = "<!-- ERROR - corrupt class file: ";
    private JarFile[] inJar;
    private Manifest[] oldManifest;
    private Manifest[] newManifest;
    private ClassTree classTree;
    private boolean hasMap = false;
    private transient ArrayList listenerList;
    private boolean replaceClassNameStrings;
    private boolean pedantic;
    private ResourceHandler resourceHandler;
    private String[] digestStrings;

    public GuardDB(File[] inFile) throws IOException {
        this.inJar = new JarFile[inFile.length];
        for (int i = 0; i < inFile.length; ++i) {
            this.inJar[i] = new JarFile(inFile[i]);
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void setResourceHandler(ResourceHandler handler) {
        this.resourceHandler = handler;
    }

    public String getOutName(String inName) {
        return this.classTree.getOutName(inName);
    }

    public void retain(Collection rgsEntries, PrintWriter log) throws IOException {
        if (this.classTree == null || this.hasMap) {
            this.hasMap = false;
            this.buildClassTree(log);
        }
        this.retainByAnnotation();
        this.retainByRule(rgsEntries, log);
    }

    private void retainByAnnotation() {
        this.classTree.walkTree(new TreeAction(){

            private ObfuscationConfig getApplyingObfuscationConfig(Cl cl) {
                ObfuscationConfig obfuscationConfig = cl.getObfuscationConfig();
                if (cl.getObfuscationConfig() != null && obfuscationConfig.applyToMembers) {
                    return obfuscationConfig;
                }
                Cl currentCl = cl;
                while (currentCl.isInnerClass()) {
                    TreeItem parent = currentCl.getParent();
                    if (parent instanceof Cl) {
                        currentCl = (Cl)parent;
                        ObfuscationConfig parentConfig = currentCl.getObfuscationConfig();
                        if (parentConfig == null || !parentConfig.applyToMembers) continue;
                        return parentConfig;
                    }
                    return null;
                }
                return null;
            }

            @Override
            public void classAction(Cl cl) {
                super.classAction(cl);
                ObfuscationConfig config = cl.getObfuscationConfig();
                if (config != null) {
                    if (config.exclude) {
                        GuardDB.this.classTree.retainClass(cl.getFullInName(), 4103, 0, 0, true);
                    }
                } else {
                    ObfuscationConfig parentConfig = this.getApplyingObfuscationConfig(cl);
                    if (parentConfig != null && parentConfig.exclude) {
                        GuardDB.this.classTree.retainClass(cl.getFullInName(), 4103, 0, 0, true);
                    }
                }
            }

            @Override
            public void methodAction(Md md) {
                super.methodAction(md);
                ObfuscationConfig config = md.getObfuscationConfig();
                if (config != null) {
                    if (config.exclude) {
                        GuardDB.this.classTree.retainMethod(md.getFullInName(), md.getDescriptor());
                    }
                } else {
                    ObfuscationConfig parentConfig = this.getApplyingObfuscationConfig((Cl)md.getParent());
                    if (parentConfig != null && parentConfig.exclude) {
                        GuardDB.this.classTree.retainMethod(md.getFullInName(), md.getDescriptor());
                    }
                }
            }

            @Override
            public void fieldAction(Fd fd) {
                super.fieldAction(fd);
                ObfuscationConfig config = fd.getObfuscationConfig();
                if (config != null) {
                    if (config.exclude) {
                        GuardDB.this.classTree.retainField(fd.getFullInName());
                    }
                } else {
                    ObfuscationConfig parentConfig = this.getApplyingObfuscationConfig((Cl)fd.getParent());
                    if (parentConfig != null && parentConfig.exclude) {
                        GuardDB.this.classTree.retainField(fd.getFullInName());
                    }
                }
            }
        });
    }

    private void retainByRule(Collection rgsEntries, PrintWriter log) {
        for (YGuardRule entry : rgsEntries) {
            try {
                switch (entry.type) {
                    case 9: {
                        this.classTree.retainLineNumberTable(entry.name, entry.lineNumberTableMapper);
                        break;
                    }
                    case 8: {
                        this.classTree.retainSourceFileAttributeMap(entry.name, entry.obfName);
                        break;
                    }
                    case 0: {
                        this.classTree.retainAttribute(entry.name);
                        break;
                    }
                    case 10: {
                        this.classTree.retainAttributeForClass(entry.descriptor, entry.name);
                        break;
                    }
                    case 1: {
                        this.classTree.retainClass(entry.name, entry.retainClasses, entry.retainMethods, entry.retainFields, true);
                        break;
                    }
                    case 3: {
                        this.classTree.retainMethod(entry.name, entry.descriptor);
                        break;
                    }
                    case 11: {
                        this.classTree.retainPackage(entry.name);
                        break;
                    }
                    case 2: {
                        this.classTree.retainField(entry.name);
                        break;
                    }
                    case 4: {
                        this.classTree.retainPackageMap(entry.name, entry.obfName);
                        break;
                    }
                    case 5: {
                        this.classTree.retainClassMap(entry.name, entry.obfName);
                        break;
                    }
                    case 7: {
                        this.classTree.retainMethodMap(entry.name, entry.descriptor, entry.obfName);
                        break;
                    }
                    case 6: {
                        this.classTree.retainFieldMap(entry.name, entry.obfName);
                        break;
                    }
                    default: {
                        throw new ParseException("Illegal type: " + entry.type);
                    }
                }
            }
            catch (RuntimeException e) {
                log.println(WARNING_SCRIPT_ENTRY_ABSENT + entry.name + " -->");
            }
        }
    }

    public void remapTo(File[] out, Filter fileFilter, PrintWriter log, boolean conserveManifest) throws IOException, ClassNotFoundException {
        if (this.classTree == null) {
            this.buildClassTree(log);
        }
        if (!this.hasMap) {
            this.createMap(log);
        }
        this.oldManifest = new Manifest[out.length];
        this.newManifest = new Manifest[out.length];
        this.parseManifest();
        StringBuffer replaceNameLog = new StringBuffer();
        StringBuffer replaceContentsLog = new StringBuffer();
        ZipOutputStream outJar = null;
        FilterInputStream inStream = null;
        OutputStream os = null;
        for (int i = 0; i < this.inJar.length; ++i) {
            os = null;
            outJar = null;
            ArrayList<Object[]> jarEntries = new ArrayList<Object[]>();
            try {
                Enumeration<JarEntry> entries = this.inJar[i].entries();
                this.fireObfuscatingJar(this.inJar[i].getName(), out[i].getName());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
                while (entries.hasMoreElements()) {
                    String outName;
                    long size;
                    JarEntry inEntry = entries.nextElement();
                    if (inEntry.isDirectory()) continue;
                    inStream = new DataInputStream(new BufferedInputStream(this.inJar[i].getInputStream(inEntry)));
                    String inName = inEntry.getName();
                    if (inName.endsWith(CLASS_EXT)) {
                        if (fileFilter != null && !fileFilter.accepts(inName)) continue;
                        ClassFile cf = ClassFile.create((DataInput)((Object)inStream));
                        this.fireObfuscatingClass(Conversion.toJavaClass(cf.getName()));
                        cf.remap(this.classTree, this.replaceClassNameStrings, log);
                        JarEntry outEntry = new JarEntry(cf.getName() + CLASS_EXT);
                        if (this.digestStrings == null) {
                            this.digestStrings = new String[]{"SHA-1", "MD5"};
                        }
                        MessageDigest[] digests = new MessageDigest[this.digestStrings.length];
                        OutputStream stream = baos;
                        for (int j = 0; j < this.digestStrings.length; ++j) {
                            MessageDigest digest;
                            String digestString = this.digestStrings[j];
                            digests[j] = digest = MessageDigest.getInstance(digestString);
                            stream = new DigestOutputStream(stream, digest);
                        }
                        DataOutputStream classOutputStream = new DataOutputStream(stream);
                        cf.write(classOutputStream);
                        classOutputStream.flush();
                        jarEntries.add(new Object[]{outEntry, baos.toByteArray()});
                        baos.reset();
                        this.updateManifest(i, inName, cf.getName() + CLASS_EXT, digests);
                        continue;
                    }
                    if (STREAM_NAME_MANIFEST.equals(inName.toUpperCase()) || inName.length() > SIGNATURE_PREFIX.length() + 1 + SIGNATURE_EXT.length() && inName.indexOf(SIGNATURE_PREFIX) != -1 && inName.substring(inName.length() - SIGNATURE_EXT.length(), inName.length()).equals(SIGNATURE_EXT) || (size = inEntry.getSize()) == -1L) continue;
                    MessageDigest shaDigest = MessageDigest.getInstance("SHA");
                    MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                    DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(new DigestOutputStream(baos, shaDigest), md5Digest));
                    StringBuffer outNameBuffer = new StringBuffer(80);
                    if (this.resourceHandler != null && this.resourceHandler.filterName(inName, outNameBuffer)) {
                        outName = outNameBuffer.toString();
                        if (!outName.equals(inName)) {
                            replaceNameLog.append("  <resource name=\"");
                            replaceNameLog.append(ClassTree.toUtf8XmlString(inName));
                            replaceNameLog.append("\" map=\"");
                            replaceNameLog.append(ClassTree.toUtf8XmlString(outName));
                            replaceNameLog.append("\"/>\n");
                        }
                    } else {
                        outName = this.classTree.getOutName(inName);
                    }
                    if (this.resourceHandler == null || !this.resourceHandler.filterContent(inStream, dataOutputStream, inName)) {
                        byte[] bytes = new byte[(int)size];
                        ((DataInputStream)inStream).readFully(bytes);
                        dataOutputStream.write(bytes, 0, bytes.length);
                    } else {
                        replaceContentsLog.append("  <resource name=\"");
                        replaceContentsLog.append(ClassTree.toUtf8XmlString(inName));
                        replaceContentsLog.append("\"/>\n");
                    }
                    dataOutputStream.flush();
                    JarEntry outEntry = new JarEntry(outName);
                    jarEntries.add(new Object[]{outEntry, baos.toByteArray()});
                    baos.reset();
                    MessageDigest[] digests = new MessageDigest[]{shaDigest, md5Digest};
                    this.updateManifest(i, inName, outName, digests);
                }
                os = new FileOutputStream(out[i]);
                outJar = conserveManifest ? new JarOutputStream((OutputStream)new BufferedOutputStream(os), this.oldManifest[i]) : new JarOutputStream((OutputStream)new BufferedOutputStream(os), this.newManifest[i]);
                outJar.setComment(Version.getJarComment());
                Collections.sort(jarEntries, new Comparator(){

                    public int compare(Object a, Object b) {
                        Object[] array1 = (Object[])a;
                        JarEntry entry1 = (JarEntry)array1[0];
                        Object[] array2 = (Object[])b;
                        JarEntry entry2 = (JarEntry)array2[0];
                        return entry1.getName().compareTo(entry2.getName());
                    }
                });
                HashSet<String> directoriesWritten = new HashSet<String>();
                for (int j = 0; j < jarEntries.size(); ++j) {
                    Object[] array = (Object[])jarEntries.get(j);
                    JarEntry entry = (JarEntry)array[0];
                    String name = entry.getName();
                    if (!entry.isDirectory()) {
                        int index = 0;
                        while ((index = name.indexOf("/", index + 1)) >= 0) {
                            String directory = name.substring(0, index + 1);
                            if (directoriesWritten.contains(directory)) continue;
                            directoriesWritten.add(directory);
                            JarEntry directoryEntry = new JarEntry(directory);
                            ((JarOutputStream)outJar).putNextEntry(directoryEntry);
                            outJar.closeEntry();
                        }
                    }
                    byte[] bytes = (byte[])array[1];
                    ((JarOutputStream)outJar).putNextEntry(entry);
                    outJar.write(bytes);
                    outJar.closeEntry();
                }
                continue;
            }
            catch (Exception e) {
                log.println();
                log.println("<!-- An exception has occured.");
                if (e instanceof ZipException) {
                    log.println("This is most likely due to a duplicate .class file in your jar!");
                    log.println("Please check that there are no out-of-date or backup duplicate .class files in your jar!");
                }
                log.println(e.toString());
                e.printStackTrace(log);
                log.println("-->");
                throw new IOException("An error ('" + e.getMessage() + "') occured during the remapping! See the log!)");
            }
            finally {
                this.inJar[i].close();
                if (inStream != null) {
                    inStream.close();
                }
                if (outJar != null) {
                    outJar.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        this.classTree.dump(log);
        if (replaceContentsLog.length() > 0 || replaceNameLog.length() > 0) {
            log.println("<!--");
            if (replaceNameLog.length() > 0) {
                log.println("\n<adjust replaceName=\"true\">");
                log.print(replaceNameLog);
                log.println("</adjust>");
            }
            if (replaceContentsLog.length() > 0) {
                log.println("\n<adjust replaceContents=\"true\">");
                log.print(replaceContentsLog);
                log.println("</adjust>");
            }
            log.println("-->");
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.inJar.length; ++i) {
            if (this.inJar[i] == null) continue;
            this.inJar[i].close();
            this.inJar[i] = null;
        }
    }

    private void parseManifest() throws IOException {
        for (int i = 0; i < this.oldManifest.length; ++i) {
            Object name;
            this.oldManifest[i] = this.inJar[i].getManifest();
            if (this.oldManifest[i] == null) {
                this.oldManifest[i] = new Manifest();
            }
            this.newManifest[i] = new Manifest();
            for (Map.Entry<Object, Object> entry : this.oldManifest[i].getMainAttributes().entrySet()) {
                name = (Attributes.Name)entry.getKey();
                String value = (String)entry.getValue();
                if (this.resourceHandler != null) {
                    name = new Attributes.Name(this.resourceHandler.filterString(((Attributes.Name)name).toString(), STREAM_NAME_MANIFEST));
                    value = this.resourceHandler.filterString(value, STREAM_NAME_MANIFEST);
                }
                this.newManifest[i].getMainAttributes().putValue(((Attributes.Name)name).toString(), value);
            }
            this.newManifest[i].getMainAttributes().putValue("Created-by", "yGuard Bytecode Obfuscator " + Version.getVersion());
            for (Map.Entry<Object, Object> entry : this.oldManifest[i].getEntries().entrySet()) {
                name = (String)entry.getKey();
                if (!((String)name).endsWith("/")) continue;
                this.newManifest[i].getEntries().put((String)name, (Attributes)entry.getValue());
            }
        }
    }

    private void updateManifest(int manifestIndex, String inName, String outName, MessageDigest[] digests) {
        Manifest nm = this.newManifest[manifestIndex];
        Manifest om = this.oldManifest[manifestIndex];
        Attributes oldAtts = om.getAttributes(inName);
        Attributes newAtts = new Attributes();
        if (oldAtts != null) {
            for (Map.Entry<Object, Object> entry : oldAtts.entrySet()) {
                Object key = entry.getKey();
                String name = key.toString();
                if (name.equalsIgnoreCase(MANIFEST_NAME_TAG) || name.indexOf("Digest") != -1) continue;
                newAtts.remove(name);
                newAtts.putValue(name, (String)entry.getValue());
            }
        }
        if (digests != null && digests.length > 0) {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < digests.length; ++i) {
                sb.append(digests[i].getAlgorithm());
                if (i >= digests.length - 1) continue;
                sb.append(", ");
            }
            newAtts.remove(MANIFEST_DIGESTALG_TAG);
            newAtts.putValue(MANIFEST_DIGESTALG_TAG, sb.toString());
            for (i = 0; i < digests.length; ++i) {
                newAtts.remove(digests[i].getAlgorithm() + "-Digest");
                newAtts.putValue(digests[i].getAlgorithm() + "-Digest", Tools.toBase64(digests[i].digest()));
            }
        }
        if (!newAtts.isEmpty()) {
            nm.getEntries().put(outName, newAtts);
        }
    }

    private void buildClassTree(PrintWriter log) throws IOException {
        this.classTree = new ClassTree();
        this.classTree.setPedantic(this.isPedantic());
        this.classTree.setReplaceClassNameStrings(this.replaceClassNameStrings);
        ClassFile.resetDangerHeader();
        HashMap<String, Object[]> parsedClasses = new HashMap<String, Object[]>();
        for (int i = 0; i < this.inJar.length; ++i) {
            Enumeration<JarEntry> entries = this.inJar[i].entries();
            this.fireParsingJar(this.inJar[i].getName());
            while (entries.hasMoreElements()) {
                ZipEntry inEntry = entries.nextElement();
                String name = inEntry.getName();
                if (!name.endsWith(CLASS_EXT)) continue;
                this.fireParsingClass(Conversion.toJavaClass(name));
                ClassFile cf = null;
                try (DataInputStream inStream = new DataInputStream(new BufferedInputStream(this.inJar[i].getInputStream(inEntry)));){
                    cf = ClassFile.create(inStream);
                }
                if (cf == null) continue;
                String cfn = cf.getName();
                String key = "module-info".equals(cfn) ? GuardDB.createModuleKey(cf) : cfn;
                Object[] old = (Object[])parsedClasses.get(key);
                if (old != null) {
                    int jarIndex = (Integer)old[0];
                    String warning = "yGuard detected a duplicate class definition for \n    " + Conversion.toJavaClass(cfn) + "\n    [" + GuardDB.createJarName(this.inJar[jarIndex], old[1].toString()) + "] in \n    [" + GuardDB.createJarName(this.inJar[i], name) + "]";
                    log.write("<!-- \n" + warning + "\n-->\n");
                    if (jarIndex == i) {
                        throw new IOException(warning + "\nPlease remove inappropriate duplicates first!");
                    }
                    if (this.pedantic) {
                        throw new IOException(warning + "\nMake sure these files are of the same version!");
                    }
                } else {
                    parsedClasses.put(key, new Object[]{new Integer(i), name});
                }
                cf.logDangerousMethods(log, this.replaceClassNameStrings);
                this.classTree.addClassFile(cf);
            }
        }
        ClassTree ct = this.classTree;
        ct.walkTree(new TreeAction(){

            @Override
            public void classAction(Cl cl) {
                if (cl.isInnerClass()) {
                    Cl parent = (Cl)cl.getParent();
                    cl.access = parent.getInnerClassModifier(cl.getInName());
                }
            }
        });
    }

    private static String createJarName(JarFile jar, String name) {
        return "jar:" + jar.getName() + "|" + name;
    }

    private static String createModuleKey(ClassFile cf) {
        return "module-info:" + cf.findModuleName();
    }

    private void createMap(PrintWriter log) throws ClassNotFoundException {
        this.classTree.generateNames();
        this.classTree.resolveClasses();
        this.hasMap = true;
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        log.println("<!--");
        log.println(LOG_MEMORY_USED + Long.toString(rt.totalMemory() - rt.freeMemory()) + LOG_MEMORY_BYTES);
        log.println(LOG_MEMORY_TOTAL + Long.toString(rt.totalMemory()) + LOG_MEMORY_BYTES);
        log.println("-->");
    }

    protected void fireParsingJar(String jar) {
        if (this.listenerList == null) {
            return;
        }
        int j = this.listenerList.size();
        for (int i = 0; i < j; ++i) {
            ((ObfuscationListener)this.listenerList.get(i)).parsingJar(jar);
        }
    }

    protected void fireParsingClass(String className) {
        if (this.listenerList == null) {
            return;
        }
        int j = this.listenerList.size();
        for (int i = 0; i < j; ++i) {
            ((ObfuscationListener)this.listenerList.get(i)).parsingClass(className);
        }
    }

    protected void fireObfuscatingJar(String inJar, String outJar) {
        if (this.listenerList == null) {
            return;
        }
        int j = this.listenerList.size();
        for (int i = 0; i < j; ++i) {
            ((ObfuscationListener)this.listenerList.get(i)).obfuscatingJar(inJar, outJar);
        }
    }

    protected void fireObfuscatingClass(String className) {
        if (this.listenerList == null) {
            return;
        }
        int j = this.listenerList.size();
        for (int i = 0; i < j; ++i) {
            ((ObfuscationListener)this.listenerList.get(i)).obfuscatingClass(className);
        }
    }

    public synchronized void addListener(ObfuscationListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(listener);
    }

    public synchronized void removeListener(ObfuscationListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    public boolean isReplaceClassNameStrings() {
        return this.replaceClassNameStrings;
    }

    public void setReplaceClassNameStrings(boolean replaceClassNameStrings) {
        this.replaceClassNameStrings = replaceClassNameStrings;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
        Cl.setPedantic(pedantic);
    }

    public String translateJavaFile(String javaClass) {
        Cl cl = this.classTree.findClassForName(javaClass.replace('/', '.'));
        if (cl != null) {
            return cl.getFullOutName();
        }
        return javaClass;
    }

    public String translateJavaClass(String javaClass) {
        Cl cl = this.classTree.findClassForName(javaClass);
        if (cl != null) {
            return cl.getFullOutName().replace('/', '.');
        }
        return javaClass;
    }

    public void setDigests(String[] digestStrings) {
        this.digestStrings = digestStrings;
    }

    public void setAnnotationClass(String annotationClass) {
        ObfuscationConfig.annotationClassName = annotationClass;
    }
}

