/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.jsonviewer.library.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yuyh.jsonviewer.library.R;

public class JsonItemView
extends LinearLayout {
    public static int TEXT_SIZE_DP = 12;
    private Context mContext;
    private TextView mTvLeft;
    private TextView mTvRight;
    private TextView mTvIcon;

    public JsonItemView(Context context) {
        this(context, null);
    }

    public JsonItemView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JsonItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.setOrientation(1);
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_json_item_view, (ViewGroup)this, true);
        this.mTvLeft = (TextView)this.findViewById(R.id.tv_left);
        this.mTvRight = (TextView)this.findViewById(R.id.tv_right);
        this.mTvIcon = (TextView)this.findViewById(R.id.tv_icon);
        if (TEXT_SIZE_DP < 10) {
            TEXT_SIZE_DP = 10;
        } else if (TEXT_SIZE_DP > 30) {
            TEXT_SIZE_DP = 30;
        }
        this.mTvLeft.setTextSize((float)TEXT_SIZE_DP);
        this.mTvRight.setTextSize((float)TEXT_SIZE_DP);
        this.mTvIcon.setTextSize((float)(TEXT_SIZE_DP - 4));
    }

    public void hideLeft() {
        this.mTvLeft.setVisibility(8);
    }

    public void showLeft(CharSequence text) {
        this.mTvLeft.setVisibility(0);
        if (text != null) {
            this.mTvLeft.setText(text);
        }
    }

    public void hideRight() {
        this.mTvRight.setVisibility(8);
    }

    public void showRight(CharSequence text) {
        this.mTvRight.setVisibility(0);
        if (text != null) {
            this.mTvRight.setText(text);
        }
    }

    public CharSequence getRightText() {
        return this.mTvRight.getText();
    }

    public void hideIcon() {
        this.mTvIcon.setVisibility(8);
    }

    public void showIcon(boolean isPlus) {
        this.mTvIcon.setVisibility(0);
        this.mTvIcon.setText((CharSequence)this.getResources().getString(isPlus ? R.string.icon_plus : R.string.icon_minus));
    }

    public void setIconClickListener(View.OnClickListener listener) {
        this.mTvIcon.setOnClickListener(listener);
    }

    public void addViewNoInvalidate(View child) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addViewInLayout(child, -1, params);
    }
}

