/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.jsonviewer.library.adapter;

import android.support.v7.widget.RecyclerView;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import com.yuyh.jsonviewer.library.adapter.BaseJsonViewerAdapter;
import com.yuyh.jsonviewer.library.utils.Utils;
import com.yuyh.jsonviewer.library.view.JsonItemView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonViewerAdapter
extends BaseJsonViewerAdapter<JsonItemViewHolder> {
    private String jsonStr;
    private JSONObject mJSONObject;
    private JSONArray mJSONArray;

    public JsonViewerAdapter(String jsonStr) {
        this.jsonStr = jsonStr;
        Object object = null;
        try {
            object = new JSONTokener(jsonStr).nextValue();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (object != null && object instanceof JSONObject) {
            this.mJSONObject = (JSONObject)object;
        } else if (object != null && object instanceof JSONArray) {
            this.mJSONArray = (JSONArray)object;
        } else {
            throw new IllegalArgumentException("jsonStr is illegal.");
        }
    }

    public JsonViewerAdapter(JSONObject jsonObject) {
        this.mJSONObject = jsonObject;
        if (this.mJSONObject == null) {
            throw new IllegalArgumentException("jsonObject can not be null.");
        }
    }

    public JsonViewerAdapter(JSONArray jsonArray) {
        this.mJSONArray = jsonArray;
        if (this.mJSONArray == null) {
            throw new IllegalArgumentException("jsonArray can not be null.");
        }
    }

    public JsonItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new JsonItemViewHolder(new JsonItemView(parent.getContext()));
    }

    public void onBindViewHolder(JsonItemViewHolder holder, int position) {
        JsonItemView itemView = holder.itemView;
        if (this.mJSONObject != null) {
            if (position == 0) {
                itemView.hideLeft();
                itemView.hideIcon();
                itemView.showRight("{");
                return;
            }
            if (position == this.getItemCount() - 1) {
                itemView.hideLeft();
                itemView.hideIcon();
                itemView.showRight("}");
                return;
            }
            String key = this.mJSONObject.names().optString(position - 1);
            Object value = this.mJSONObject.opt(key);
            if (position < this.getItemCount() - 2) {
                this.handleJsonObject(key, value, itemView, true, 1);
            } else {
                this.handleJsonObject(key, value, itemView, false, 1);
            }
        }
        if (this.mJSONArray != null) {
            if (position == 0) {
                itemView.hideLeft();
                itemView.hideIcon();
                itemView.showRight("[");
                return;
            }
            if (position == this.getItemCount() - 1) {
                itemView.hideLeft();
                itemView.hideIcon();
                itemView.showRight("]");
                return;
            }
            Object value = this.mJSONArray.opt(position - 1);
            if (position < this.getItemCount() - 2) {
                this.handleJsonArray(value, itemView, true, 1);
            } else {
                this.handleJsonArray(value, itemView, false, 1);
            }
        }
    }

    public int getItemCount() {
        if (this.mJSONObject != null) {
            return this.mJSONObject.names().length() + 2;
        }
        if (this.mJSONArray != null) {
            return this.mJSONArray.length() + 2;
        }
        return 0;
    }

    private void handleJsonObject(String key, Object value, JsonItemView itemView, boolean appendComma, int hierarchy) {
        SpannableStringBuilder keyBuilder = new SpannableStringBuilder((CharSequence)Utils.getHierarchyStr(hierarchy));
        keyBuilder.append((CharSequence)"\"").append((CharSequence)key).append((CharSequence)"\"").append((CharSequence)":");
        keyBuilder.setSpan((Object)keySpan, 0, keyBuilder.length() - 1, 33);
        keyBuilder.setSpan((Object)bracesSpan, keyBuilder.length() - 1, keyBuilder.length(), 33);
        itemView.showLeft((CharSequence)keyBuilder);
        this.handleValue(value, itemView, appendComma, hierarchy);
    }

    private void handleJsonArray(Object value, JsonItemView itemView, boolean appendComma, int hierarchy) {
        itemView.showLeft((CharSequence)new SpannableStringBuilder((CharSequence)Utils.getHierarchyStr(hierarchy)));
        this.handleValue(value, itemView, appendComma, hierarchy);
    }

    private void handleValue(Object value, JsonItemView itemView, boolean appendComma, int hierarchy) {
        SpannableStringBuilder valueBuilder = new SpannableStringBuilder();
        if (value instanceof Number) {
            valueBuilder.append((CharSequence)value.toString());
            valueBuilder.setSpan((Object)numberSpan, 0, valueBuilder.length(), 33);
        } else if (value instanceof JSONObject) {
            itemView.showIcon(true);
            valueBuilder.append((CharSequence)"Object{...}");
            itemView.setIconClickListener(new JsonItemClickListener(value, itemView, appendComma, hierarchy + 1));
        } else if (value instanceof JSONArray) {
            itemView.showIcon(true);
            valueBuilder.append((CharSequence)"Array[").append((CharSequence)String.valueOf(((JSONArray)value).length())).append((CharSequence)"]");
            valueBuilder.setSpan((Object)bracesSpan, 0, 6, 33);
            valueBuilder.setSpan((Object)numberSpan, 6, valueBuilder.length() - 1, 33);
            valueBuilder.setSpan((Object)bracesSpan, valueBuilder.length() - 1, valueBuilder.length(), 33);
            itemView.setIconClickListener(new JsonItemClickListener(value, itemView, appendComma, hierarchy + 1));
        } else if (value instanceof String) {
            itemView.hideIcon();
            valueBuilder.append((CharSequence)"\"").append((CharSequence)value.toString()).append((CharSequence)"\"");
            if (Utils.isUrl(value.toString())) {
                valueBuilder.setSpan((Object)textSpan, 0, 1, 33);
                valueBuilder.setSpan((Object)urlSpan, 1, valueBuilder.length() - 1, 33);
                valueBuilder.setSpan((Object)textSpan, valueBuilder.length() - 1, valueBuilder.length(), 33);
            } else {
                valueBuilder.setSpan((Object)textSpan, 0, valueBuilder.length(), 33);
            }
        } else if (valueBuilder.length() == 0 || value == null) {
            itemView.hideIcon();
            valueBuilder.append((CharSequence)"null");
            valueBuilder.setSpan((Object)nullSpan, 0, valueBuilder.length(), 33);
        }
        if (appendComma) {
            valueBuilder.append((CharSequence)",");
        }
        itemView.showRight((CharSequence)valueBuilder);
    }

    class JsonItemViewHolder
    extends RecyclerView.ViewHolder {
        JsonItemView itemView;

        JsonItemViewHolder(JsonItemView itemView) {
            super((View)itemView);
            this.setIsRecyclable(false);
            this.itemView = itemView;
        }
    }

    class JsonItemClickListener
    implements View.OnClickListener {
        private Object value;
        private JsonItemView itemView;
        private boolean appendComma;
        private int hierarchy;
        private boolean isCollapsed = true;
        private boolean isJsonArray;

        JsonItemClickListener(Object value, JsonItemView itemView, boolean appendComma, int hierarchy) {
            this.value = value;
            this.itemView = itemView;
            this.appendComma = appendComma;
            this.hierarchy = hierarchy;
            this.isJsonArray = value != null && value instanceof JSONArray;
        }

        public void onClick(View view) {
            if (this.itemView.getChildCount() == 1) {
                this.isCollapsed = false;
                this.itemView.showIcon(false);
                this.itemView.setTag(this.itemView.getRightText());
                this.itemView.showRight(this.isJsonArray ? "[" : "{");
                JSONArray array = this.isJsonArray ? (JSONArray)this.value : ((JSONObject)this.value).names();
                for (int i = 0; i < array.length(); ++i) {
                    JsonItemView childItemView = new JsonItemView(this.itemView.getContext());
                    Object childValue = array.opt(i);
                    if (this.isJsonArray) {
                        JsonViewerAdapter.this.handleJsonArray(childValue, childItemView, i < array.length() - 1, this.hierarchy);
                    } else {
                        JsonViewerAdapter.this.handleJsonObject((String)childValue, ((JSONObject)this.value).opt((String)childValue), childItemView, i < array.length() - 1, this.hierarchy);
                    }
                    this.itemView.addViewNoInvalidate((View)childItemView);
                }
                JsonItemView childItemView = new JsonItemView(this.itemView.getContext());
                StringBuilder builder = new StringBuilder(Utils.getHierarchyStr(this.hierarchy - 1));
                builder.append(this.isJsonArray ? "]" : "}").append(this.appendComma ? "," : "");
                childItemView.showRight(builder);
                this.itemView.addViewNoInvalidate((View)childItemView);
                this.itemView.requestLayout();
                this.itemView.invalidate();
            } else {
                CharSequence temp = this.itemView.getRightText();
                this.itemView.showRight((CharSequence)this.itemView.getTag());
                this.itemView.setTag(temp);
                this.itemView.showIcon(!this.isCollapsed);
                for (int i = 1; i < this.itemView.getChildCount(); ++i) {
                    this.itemView.getChildAt(i).setVisibility(this.isCollapsed ? 0 : 8);
                }
                this.isCollapsed = !this.isCollapsed;
            }
        }
    }
}

