/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.jsonviewer.library;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import com.yuyh.jsonviewer.library.adapter.BaseJsonViewerAdapter;
import com.yuyh.jsonviewer.library.adapter.JsonViewerAdapter;
import com.yuyh.jsonviewer.library.view.JsonItemView;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonRecyclerView
extends RecyclerView {
    private BaseJsonViewerAdapter mAdapter;

    public JsonRecyclerView(Context context) {
        this(context, null);
    }

    public JsonRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JsonRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    public void bindJson(String jsonStr) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(jsonStr);
        this.setAdapter(this.mAdapter);
    }

    public void bindJson(JSONArray array) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(array);
        this.setAdapter(this.mAdapter);
    }

    public void bindJson(JSONObject object) {
        this.mAdapter = null;
        this.mAdapter = new JsonViewerAdapter(object);
        this.setAdapter(this.mAdapter);
    }

    public void setKeyColor(int color) {
        BaseJsonViewerAdapter.keySpan = new ForegroundColorSpan(color);
    }

    public void setValueTextColor(int color) {
        BaseJsonViewerAdapter.textSpan = new ForegroundColorSpan(color);
    }

    public void setValueNumberColor(int color) {
        BaseJsonViewerAdapter.numberSpan = new ForegroundColorSpan(color);
    }

    public void setValueUrlColor(int color) {
        BaseJsonViewerAdapter.urlSpan = new ForegroundColorSpan(color);
    }

    public void setValueNullColor(int color) {
        BaseJsonViewerAdapter.nullSpan = new ForegroundColorSpan(color);
    }

    public void setBracesColor(int color) {
        BaseJsonViewerAdapter.bracesSpan = new ForegroundColorSpan(color);
    }

    public void setTextSize(int sizeDP) {
        JsonItemView.TEXT_SIZE_DP = sizeDP;
    }
}

