/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.ui.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.transition.Fade;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.ListPopupWindow;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.CursorLoader;
import androidx.loader.content.Loader;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.adapter.FolderListAdapter;
import com.yuyh.library.imgsel.adapter.ImageListAdapter;
import com.yuyh.library.imgsel.adapter.PreviewAdapter;
import com.yuyh.library.imgsel.bean.Folder;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.common.Callback;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.common.OnFolderChangeListener;
import com.yuyh.library.imgsel.common.OnItemClickListener;
import com.yuyh.library.imgsel.config.ISListConfig;
import com.yuyh.library.imgsel.ui.ISListActivity;
import com.yuyh.library.imgsel.utils.DisplayUtils;
import com.yuyh.library.imgsel.utils.FileUtils;
import com.yuyh.library.imgsel.utils.LogUtils;
import com.yuyh.library.imgsel.widget.CustomViewPager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImgSelFragment
extends Fragment
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private RecyclerView rvImageList;
    private Button btnAlbumSelected;
    private View rlBottom;
    private CustomViewPager viewPager;
    private ISListConfig config;
    private Callback callback;
    private List<Folder> folderList = new ArrayList<Folder>();
    private List<Image> imageList = new ArrayList<Image>();
    private ListPopupWindow folderPopupWindow;
    private ImageListAdapter imageListAdapter;
    private FolderListAdapter folderListAdapter;
    private PreviewAdapter previewAdapter;
    private boolean hasFolderGened = false;
    private static final int LOADER_ALL = 0;
    private static final int LOADER_CATEGORY = 1;
    private static final int REQUEST_CAMERA = 5;
    private static final int CAMERA_REQUEST_CODE = 1;
    private File tempFile;
    private LoaderManager.LoaderCallbacks<Cursor> mLoaderCallback = new LoaderManager.LoaderCallbacks<Cursor>(){
        private final String[] IMAGE_PROJECTION = new String[]{"_data", "_display_name", "_id"};

        public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
            if (id2 == 0) {
                return new CursorLoader((Context)ImgSelFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, null, null, "date_added DESC");
            }
            if (id2 == 1) {
                return new CursorLoader((Context)ImgSelFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[0] + " not like '%.gif%'", null, "date_added DESC");
            }
            return null;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
            int count;
            if (data != null && (count = data.getCount()) > 0) {
                ArrayList<Image> tempImageList = new ArrayList<Image>();
                data.moveToFirst();
                do {
                    File imageFile;
                    File folderFile;
                    String path = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[0]));
                    String name = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[1]));
                    Image image = new Image(path, name);
                    tempImageList.add(image);
                    if (ImgSelFragment.this.hasFolderGened || (folderFile = (imageFile = new File(path)).getParentFile()) == null || !imageFile.exists() || imageFile.length() < 10L) continue;
                    Folder parent = null;
                    for (Folder folder : ImgSelFragment.this.folderList) {
                        if (!TextUtils.equals((CharSequence)folder.path, (CharSequence)folderFile.getAbsolutePath())) continue;
                        parent = folder;
                    }
                    if (parent != null) {
                        parent.images.add(image);
                        continue;
                    }
                    parent = new Folder();
                    parent.name = folderFile.getName();
                    parent.path = folderFile.getAbsolutePath();
                    parent.cover = image;
                    ArrayList<Image> imageList = new ArrayList<Image>();
                    imageList.add(image);
                    parent.images = imageList;
                    ImgSelFragment.this.folderList.add(parent);
                } while (data.moveToNext());
                ImgSelFragment.this.imageList.clear();
                if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                    ImgSelFragment.this.imageList.add(new Image());
                }
                ImgSelFragment.this.imageList.addAll(tempImageList);
                ImgSelFragment.this.imageListAdapter.notifyDataSetChanged();
                ImgSelFragment.this.folderListAdapter.notifyDataSetChanged();
                ImgSelFragment.this.hasFolderGened = true;
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    };

    public static ImgSelFragment instance() {
        ImgSelFragment fragment = new ImgSelFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_img_sel, container, false);
        this.rvImageList = (RecyclerView)view.findViewById(R.id.rvImageList);
        this.btnAlbumSelected = (Button)view.findViewById(R.id.btnAlbumSelected);
        this.btnAlbumSelected.setOnClickListener((View.OnClickListener)this);
        this.rlBottom = view.findViewById(R.id.rlBottom);
        this.viewPager = (CustomViewPager)view.findViewById(R.id.viewPager);
        this.viewPager.setOffscreenPageLimit(1);
        this.viewPager.addOnPageChangeListener(this);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.config = ((ISListActivity)this.getActivity()).getConfig();
        this.callback = (ISListActivity)this.getActivity();
        if (this.config == null) {
            Log.e((String)"ImgSelFragment", (String)"config \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.btnAlbumSelected.setText((CharSequence)this.config.allImagesText);
        this.rvImageList.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.rvImageList.getContext(), 3));
        this.rvImageList.addItemDecoration(new RecyclerView.ItemDecoration(){
            int spacing;
            int halfSpacing;
            {
                this.spacing = DisplayUtils.dip2px(ImgSelFragment.this.rvImageList.getContext(), 6.0f);
                this.halfSpacing = this.spacing >> 1;
            }

            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                outRect.left = this.halfSpacing;
                outRect.right = this.halfSpacing;
                outRect.top = this.halfSpacing;
                outRect.bottom = this.halfSpacing;
            }
        });
        if (this.config.needCamera) {
            this.imageList.add(new Image());
        }
        this.imageListAdapter = new ImageListAdapter((Context)this.getActivity(), this.imageList, this.config);
        this.imageListAdapter.setShowCamera(this.config.needCamera);
        this.imageListAdapter.setMutiSelect(this.config.multiSelect);
        this.rvImageList.setAdapter((RecyclerView.Adapter)this.imageListAdapter);
        this.imageListAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public int onCheckedClick(int position, Image image) {
                return ImgSelFragment.this.checkedImage(position, image);
            }

            @Override
            public void onImageClick(int position, Image image) {
                if (((ImgSelFragment)ImgSelFragment.this).config.needCamera && position == 0) {
                    ImgSelFragment.this.showCameraAction();
                } else if (((ImgSelFragment)ImgSelFragment.this).config.multiSelect) {
                    TransitionManager.go((Scene)new Scene((ViewGroup)ImgSelFragment.this.viewPager), (Transition)new Fade().setDuration(200L));
                    ImgSelFragment.this.viewPager.setAdapter(ImgSelFragment.this.previewAdapter = new PreviewAdapter((Activity)ImgSelFragment.this.getActivity(), ImgSelFragment.this.imageList, ImgSelFragment.this.config));
                    ImgSelFragment.this.previewAdapter.setListener(new OnItemClickListener(){

                        @Override
                        public int onCheckedClick(int position, Image image) {
                            return ImgSelFragment.this.checkedImage(position, image);
                        }

                        @Override
                        public void onImageClick(int position, Image image) {
                            ImgSelFragment.this.hidePreview();
                        }
                    });
                    if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                        ImgSelFragment.this.callback.onPreviewChanged(position, ImgSelFragment.this.imageList.size() - 1, true);
                    } else {
                        ImgSelFragment.this.callback.onPreviewChanged(position + 1, ImgSelFragment.this.imageList.size(), true);
                    }
                    ImgSelFragment.this.viewPager.setCurrentItem(((ImgSelFragment)ImgSelFragment.this).config.needCamera ? position - 1 : position);
                    ImgSelFragment.this.viewPager.setVisibility(0);
                } else if (ImgSelFragment.this.callback != null) {
                    ImgSelFragment.this.callback.onSingleImageSelected(image.path);
                }
            }
        });
        this.folderListAdapter = new FolderListAdapter((Context)this.getActivity(), this.folderList, this.config);
        this.getActivity().getSupportLoaderManager().initLoader(0, null, this.mLoaderCallback);
    }

    private int checkedImage(int position, Image image) {
        if (image != null) {
            if (Constant.imageList.contains(image.path)) {
                Constant.imageList.remove(image.path);
                if (this.callback != null) {
                    this.callback.onImageUnselected(image.path);
                }
            } else {
                if (this.config.maxNum <= Constant.imageList.size()) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)String.format(this.getString(R.string.maxnum), this.config.maxNum), (int)0).show();
                    return 0;
                }
                Constant.imageList.add(image.path);
                if (this.callback != null) {
                    this.callback.onImageSelected(image.path);
                }
            }
            return 1;
        }
        return 0;
    }

    private void createPopupFolderList(int width, int height) {
        this.folderPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.folderPopupWindow.setAnimationStyle(R.style.PopupAnimBottom);
        this.folderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.folderPopupWindow.setAdapter((ListAdapter)this.folderListAdapter);
        this.folderPopupWindow.setContentWidth(width);
        this.folderPopupWindow.setWidth(width);
        this.folderPopupWindow.setHeight(-2);
        this.folderPopupWindow.setAnchorView(this.rlBottom);
        this.folderPopupWindow.setModal(true);
        this.folderListAdapter.setOnFloderChangeListener(new OnFolderChangeListener(){

            @Override
            public void onChange(int position, Folder folder) {
                ImgSelFragment.this.folderPopupWindow.dismiss();
                if (position == 0) {
                    ImgSelFragment.this.getActivity().getSupportLoaderManager().restartLoader(0, null, ImgSelFragment.this.mLoaderCallback);
                    ImgSelFragment.this.btnAlbumSelected.setText((CharSequence)((ImgSelFragment)ImgSelFragment.this).config.allImagesText);
                } else {
                    ImgSelFragment.this.imageList.clear();
                    if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                        ImgSelFragment.this.imageList.add(new Image());
                    }
                    ImgSelFragment.this.imageList.addAll(folder.images);
                    ImgSelFragment.this.imageListAdapter.notifyDataSetChanged();
                    ImgSelFragment.this.btnAlbumSelected.setText((CharSequence)folder.name);
                }
            }
        });
        this.folderPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                ImgSelFragment.this.setBackgroundAlpha(1.0f);
            }
        });
    }

    public void setBackgroundAlpha(float bgAlpha) {
        WindowManager.LayoutParams lp = this.getActivity().getWindow().getAttributes();
        lp.alpha = bgAlpha;
        this.getActivity().getWindow().setAttributes(lp);
    }

    public void onClick(View v) {
        WindowManager wm = this.getActivity().getWindowManager();
        final int size = wm.getDefaultDisplay().getWidth() / 3 * 2;
        if (v.getId() == this.btnAlbumSelected.getId()) {
            if (this.folderPopupWindow == null) {
                this.createPopupFolderList(size, size);
            }
            if (this.folderPopupWindow.isShowing()) {
                this.folderPopupWindow.dismiss();
            } else {
                int index;
                this.folderPopupWindow.show();
                if (this.folderPopupWindow.getListView() != null) {
                    this.folderPopupWindow.getListView().setDivider((Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.bottom_bg)));
                }
                index = (index = this.folderListAdapter.getSelectIndex()) == 0 ? index : index - 1;
                this.folderPopupWindow.getListView().setSelection(index);
                this.folderPopupWindow.getListView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        if (Build.VERSION.SDK_INT < 16) {
                            ImgSelFragment.this.folderPopupWindow.getListView().getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            ImgSelFragment.this.folderPopupWindow.getListView().getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                        int h = ImgSelFragment.this.folderPopupWindow.getListView().getMeasuredHeight();
                        if (h > size) {
                            ImgSelFragment.this.folderPopupWindow.setHeight(size);
                            ImgSelFragment.this.folderPopupWindow.show();
                        }
                    }
                });
                this.setBackgroundAlpha(0.6f);
            }
        }
    }

    private void showCameraAction() {
        if (this.config.maxNum <= Constant.imageList.size()) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)String.format(this.getString(R.string.maxnum), this.config.maxNum), (int)0).show();
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 1);
            return;
        }
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.tempFile = new File(FileUtils.createRootPath((Context)this.getActivity()) + "/" + System.currentTimeMillis() + ".jpg");
            LogUtils.e(this.tempFile.getAbsolutePath());
            FileUtils.createFile(this.tempFile);
            Uri uri = FileProvider.getUriForFile((Context)this.getActivity(), (String)(FileUtils.getApplicationId((Context)this.getActivity()) + ".image_provider"), (File)this.tempFile);
            List resInfoList = this.getActivity().getPackageManager().queryIntentActivities(cameraIntent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                this.getActivity().grantUriPermission(packageName, uri, 3);
            }
            cameraIntent.putExtra("output", (Parcelable)uri);
            this.startActivityForResult(cameraIntent, 5);
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.open_camera_failure), (int)0).show();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 5) {
            if (resultCode == -1) {
                if (this.tempFile != null && this.callback != null) {
                    this.callback.onCameraShot(this.tempFile);
                }
            } else if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length >= 1 && grantResults[0] == 0) {
                    this.showCameraAction();
                    break;
                }
                Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.permission_camera_denied), (int)0).show();
                break;
            }
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (this.config.needCamera) {
            this.callback.onPreviewChanged(position + 1, this.imageList.size() - 1, true);
        } else {
            this.callback.onPreviewChanged(position + 1, this.imageList.size(), true);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public boolean hidePreview() {
        if (this.viewPager.getVisibility() == 0) {
            TransitionManager.go((Scene)new Scene((ViewGroup)this.viewPager), (Transition)new Fade().setDuration(200L));
            this.viewPager.setVisibility(8);
            this.callback.onPreviewChanged(0, 0, false);
            this.imageListAdapter.notifyDataSetChanged();
            return true;
        }
        return false;
    }
}

