/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.config.ISCameraConfig;
import com.yuyh.library.imgsel.utils.FileUtils;
import com.yuyh.library.imgsel.utils.LogUtils;
import com.yuyh.library.imgsel.utils.StatusBarCompat;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class ISCameraActivity
extends AppCompatActivity {
    private static final int REQUEST_CAMERA = 5;
    private static final int IMAGE_CROP_CODE = 1;
    private static final int CAMERA_REQUEST_CODE = 2;
    private File cropImageFile;
    private File tempPhotoFile;
    private ISCameraConfig config;

    public static void startForResult(Activity activity, ISCameraConfig config, int requestCode) {
        Intent intent = new Intent((Context)activity, ISCameraActivity.class);
        intent.putExtra("config", (Serializable)config);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startForResult(androidx.fragment.app.Fragment fragment, ISCameraConfig config, int requestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), ISCameraActivity.class);
        intent.putExtra("config", (Serializable)config);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void startForResult(Fragment fragment, ISCameraConfig config, int requestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), ISCameraActivity.class);
        intent.putExtra("config", (Serializable)config);
        fragment.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        StatusBarCompat.compatTransStatusBar((Activity)this, 0x33333333);
        super.onCreate(savedInstanceState);
        this.config = (ISCameraConfig)this.getIntent().getSerializableExtra("config");
        if (this.config == null) {
            return;
        }
        this.camera();
    }

    private void camera() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0 || ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 2);
            return;
        }
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            this.tempPhotoFile = new File(FileUtils.createRootPath((Context)this) + "/" + System.currentTimeMillis() + ".jpg");
            LogUtils.e(this.tempPhotoFile.getAbsolutePath());
            FileUtils.createFile(this.tempPhotoFile);
            Uri uri = FileProvider.getUriForFile((Context)this, (String)(FileUtils.getApplicationId((Context)this) + ".image_provider"), (File)this.tempPhotoFile);
            List resInfoList = this.getPackageManager().queryIntentActivities(cameraIntent, 65536);
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                this.grantUriPermission(packageName, uri, 3);
            }
            cameraIntent.putExtra("output", (Parcelable)uri);
            this.startActivityForResult(cameraIntent, 5);
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.open_camera_failure), (int)0).show();
        }
    }

    private void crop(String imagePath) {
        this.cropImageFile = new File(FileUtils.createRootPath((Context)this) + "/" + System.currentTimeMillis() + ".jpg");
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(this.getImageContentUri(new File(imagePath)), "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", this.config.aspectX);
        intent.putExtra("aspectY", this.config.aspectY);
        intent.putExtra("outputX", this.config.outputX);
        intent.putExtra("outputY", this.config.outputY);
        intent.putExtra("scale", true);
        intent.putExtra("scaleUpIfNeeded", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)this.cropImageFile));
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent.putExtra("noFaceDetection", true);
        this.startActivityForResult(intent, 1);
    }

    public Uri getImageContentUri(File imageFile) {
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            cursor.close();
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        if (imageFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            if (cursor != null) {
                cursor.close();
            }
            return this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return null;
    }

    private void complete(Image image) {
        Intent intent = new Intent();
        if (image != null) {
            intent.putExtra("result", image.path);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            this.complete(new Image(this.cropImageFile.getPath(), this.cropImageFile.getName()));
        } else if (requestCode == 5) {
            if (resultCode == -1) {
                if (this.tempPhotoFile != null) {
                    if (this.config.needCrop) {
                        this.crop(this.tempPhotoFile.getAbsolutePath());
                    } else {
                        this.complete(new Image(this.tempPhotoFile.getPath(), this.tempPhotoFile.getName()));
                    }
                }
            } else {
                if (this.tempPhotoFile != null && this.tempPhotoFile.exists()) {
                    this.tempPhotoFile.delete();
                }
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 2: {
                if (grantResults.length >= 2 && grantResults[0] == 0 && grantResults[1] == 0) {
                    this.camera();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.permission_camera_denied), (int)0).show();
                break;
            }
        }
    }
}

