/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yuyh.library.imgsel.common.ImageLoader;
import com.yuyh.library.imgsel.config.ISCameraConfig;
import com.yuyh.library.imgsel.config.ISListConfig;
import com.yuyh.library.imgsel.ui.ISCameraActivity;
import com.yuyh.library.imgsel.ui.ISListActivity;

public class ISNav {
    private static ISNav instance;
    private ImageLoader loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISNav getInstance() {
        if (instance != null) return instance;
        Class<ISNav> clazz = ISNav.class;
        synchronized (ISNav.class) {
            if (instance != null) return instance;
            instance = new ISNav();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(@NonNull ImageLoader loader) {
        this.loader = loader;
    }

    public void displayImage(Context context, String path, ImageView imageView) {
        if (this.loader != null) {
            this.loader.displayImage(context, path, imageView);
        }
    }

    public void toListActivity(Object source, ISListConfig config, int reqCode) {
        if (source instanceof Activity) {
            ISListActivity.startForResult((Activity)source, config, reqCode);
        } else if (source instanceof androidx.fragment.app.Fragment) {
            ISListActivity.startForResult((androidx.fragment.app.Fragment)source, config, reqCode);
        } else if (source instanceof Fragment) {
            ISListActivity.startForResult((Fragment)source, config, reqCode);
        }
    }

    public void toCameraActivity(Object source, ISCameraConfig config, int reqCode) {
        if (source instanceof Activity) {
            ISCameraActivity.startForResult((Activity)source, config, reqCode);
        } else if (source instanceof androidx.fragment.app.Fragment) {
            ISCameraActivity.startForResult((androidx.fragment.app.Fragment)source, config, reqCode);
        } else if (source instanceof Fragment) {
            ISCameraActivity.startForResult((Fragment)source, config, reqCode);
        }
    }
}

