/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.utils;

import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AndroidRomUtil {
    private static final String KEY_EMUI_VERSION_CODE = "ro.build.version.emui";
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_MIUI_INTERNAL_STORAGE = "ro.miui.internal.storage";

    public static boolean isEMUI() {
        try {
            BuildProperties prop = BuildProperties.newInstance();
            return prop.getProperty(KEY_EMUI_VERSION_CODE, null) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isMIUI() {
        try {
            BuildProperties prop = BuildProperties.newInstance();
            return prop.getProperty(KEY_MIUI_VERSION_CODE, null) != null || prop.getProperty(KEY_MIUI_VERSION_NAME, null) != null || prop.getProperty(KEY_MIUI_INTERNAL_STORAGE, null) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isFlyme() {
        try {
            Method method = Build.class.getMethod("hasSmartBar", new Class[0]);
            return method != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class BuildProperties {
        private final Properties properties = new Properties();

        private BuildProperties() throws IOException {
            this.properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
        }

        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.properties.entrySet();
        }

        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public String getProperty(String name, String defaultValue) {
            return this.properties.getProperty(name, defaultValue);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public Enumeration<Object> keys() {
            return this.properties.keys();
        }

        public Set<Object> keySet() {
            return this.properties.keySet();
        }

        public int size() {
            return this.properties.size();
        }

        public Collection<Object> values() {
            return this.properties.values();
        }

        public static BuildProperties newInstance() throws IOException {
            return new BuildProperties();
        }
    }
}

