/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.utils.AndroidRomUtil;

public class StatusBarCompat {
    @TargetApi(value=21)
    public static View compat(Activity activity, int statusColor) {
        int color2 = ContextCompat.getColor((Context)activity, (int)R.color.colorPrimary);
        if (color2 == statusColor) {
            StatusBarCompat.compatTransStatusBar(activity, 0);
        } else {
            StatusBarCompat.compatTransStatusBar(activity, statusColor);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
            View statusBarView = contentView.getChildAt(0);
            if (statusBarView != null && statusBarView.getMeasuredHeight() == StatusBarCompat.getStatusBarHeight((Context)activity)) {
                statusBarView.setBackgroundColor(statusColor);
                return statusBarView;
            }
            statusBarView = new View((Context)activity);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, StatusBarCompat.getStatusBarHeight((Context)activity));
            statusBarView.setBackgroundColor(color2);
            contentView.addView(statusBarView, lp);
            return statusBarView;
        }
        return null;
    }

    @TargetApi(value=19)
    public static void compatTransStatusBar(Activity activity, int color2) {
        if (Build.VERSION.SDK_INT >= 19) {
            View decorView = activity.getWindow().getDecorView();
            int option = 1280;
            decorView.setSystemUiVisibility(option);
            if (Build.VERSION.SDK_INT >= 21) {
                if (AndroidRomUtil.isEMUI()) {
                    activity.getWindow().addFlags(0x4000000);
                } else {
                    activity.getWindow().addFlags(Integer.MIN_VALUE);
                }
                activity.getWindow().setStatusBarColor(color2);
            } else {
                activity.getWindow().addFlags(0x4000000);
            }
        }
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }
}

