/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import com.yuyh.library.imgsel.utils.LogUtils;
import java.io.File;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();

    public static String createRootPath(Context context) {
        String cacheRootPath = "";
        cacheRootPath = FileUtils.isSdCardAvailable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return cacheRootPath;
    }

    public static boolean isSdCardAvailable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String createDir(String dirPath) {
        try {
            File file = new File(dirPath);
            if (file.getParentFile().exists()) {
                LogUtils.i("----- \u521b\u5efa\u6587\u4ef6\u5939" + file.getAbsolutePath());
                file.mkdir();
                return file.getAbsolutePath();
            }
            FileUtils.createDir(file.getParentFile().getAbsolutePath());
            LogUtils.i("----- \u521b\u5efa\u6587\u4ef6\u5939" + file.getAbsolutePath());
            file.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dirPath;
    }

    public static String createFile(File file) {
        try {
            if (file.getParentFile().exists()) {
                LogUtils.i("----- \u521b\u5efa\u6587\u4ef6" + file.getAbsolutePath());
                file.createNewFile();
                return file.getAbsolutePath();
            }
            FileUtils.createDir(file.getParentFile().getAbsolutePath());
            file.createNewFile();
            LogUtils.i("----- \u521b\u5efa\u6587\u4ef6" + file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getApplicationId(Context appContext) throws IllegalArgumentException {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = appContext.getPackageManager().getApplicationInfo(appContext.getPackageName(), 128);
            if (applicationInfo == null) {
                throw new IllegalArgumentException(" get application info = null, has no meta data! ");
            }
            LogUtils.d(appContext.getPackageName() + " " + applicationInfo.metaData.getString("APP_ID"));
            return applicationInfo.metaData.getString("APP_ID");
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException(" get application info error! ", e);
        }
    }
}

