/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.ImgSelFragment;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.common.Callback;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.utils.FileUtils;
import com.yuyh.library.imgsel.utils.StatusBarCompat;
import java.io.File;
import java.util.ArrayList;

public class ImgSelActivity
extends FragmentActivity
implements View.OnClickListener,
Callback {
    public static final String INTENT_RESULT = "result";
    private static final int IMAGE_CROP_CODE = 1;
    private static final int STORAGE_REQUEST_CODE = 1;
    private ImgSelConfig config;
    private RelativeLayout rlTitleBar;
    private TextView tvTitle;
    private Button btnConfirm;
    private ImageView ivBack;
    private String cropImagePath;
    private ImgSelFragment fragment;
    private ArrayList<String> result = new ArrayList();

    public static void startActivity(Activity activity, ImgSelConfig config, int RequestCode) {
        Intent intent = new Intent((Context)activity, ImgSelActivity.class);
        Constant.config = config;
        activity.startActivityForResult(intent, RequestCode);
    }

    public static void startActivity(Fragment fragment, ImgSelConfig config, int RequestCode) {
        Intent intent = new Intent((Context)fragment.getActivity(), ImgSelActivity.class);
        Constant.config = config;
        fragment.startActivityForResult(intent, RequestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_img_sel);
        this.config = Constant.config;
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
        } else {
            this.fragment = ImgSelFragment.instance();
            this.getSupportFragmentManager().beginTransaction().add(R.id.fmImageList, (Fragment)this.fragment, null).commit();
        }
        this.initView();
        if (!FileUtils.isSdCardAvailable()) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.sd_disable), (int)0).show();
        }
    }

    private void initView() {
        this.rlTitleBar = (RelativeLayout)this.findViewById(R.id.rlTitleBar);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.btnConfirm = (Button)this.findViewById(R.id.btnConfirm);
        this.btnConfirm.setOnClickListener((View.OnClickListener)this);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        if (this.config != null) {
            if (this.config.backResId != -1) {
                this.ivBack.setImageResource(this.config.backResId);
            }
            if (this.config.statusBarColor != -1) {
                StatusBarCompat.compat((Activity)this, this.config.statusBarColor);
                if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
                    this.getWindow().addFlags(0x4000000);
                }
            }
            this.rlTitleBar.setBackgroundColor(this.config.titleBgColor);
            this.tvTitle.setTextColor(this.config.titleColor);
            this.tvTitle.setText((CharSequence)this.config.title);
            this.btnConfirm.setBackgroundColor(this.config.btnBgColor);
            this.btnConfirm.setTextColor(this.config.btnTextColor);
            if (this.config.multiSelect) {
                if (!this.config.rememberSelected) {
                    Constant.imageList.clear();
                }
                this.btnConfirm.setText((CharSequence)String.format(this.getString(R.string.confirm_format), this.config.btnText, Constant.imageList.size(), this.config.maxNum));
            } else {
                Constant.imageList.clear();
                this.btnConfirm.setVisibility(8);
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnConfirm) {
            if (Constant.imageList != null && !Constant.imageList.isEmpty()) {
                this.exit();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.minnum), (int)0).show();
            }
        } else if (id2 == R.id.ivBack) {
            this.onBackPressed();
        }
    }

    @Override
    public void onSingleImageSelected(String path) {
        if (this.config.needCrop) {
            this.crop(path);
        } else {
            Constant.imageList.add(path);
            this.exit();
        }
    }

    @Override
    public void onImageSelected(String path) {
        this.btnConfirm.setText((CharSequence)String.format(this.getString(R.string.confirm_format), this.config.btnText, Constant.imageList.size(), this.config.maxNum));
    }

    @Override
    public void onImageUnselected(String path) {
        this.btnConfirm.setText((CharSequence)String.format(this.getString(R.string.confirm_format), this.config.btnText, Constant.imageList.size(), this.config.maxNum));
    }

    @Override
    public void onCameraShot(File imageFile) {
        if (imageFile != null) {
            if (this.config.needCrop) {
                this.crop(imageFile.getAbsolutePath());
            } else {
                Constant.imageList.add(imageFile.getAbsolutePath());
                this.config.multiSelect = false;
                this.exit();
            }
        }
    }

    @Override
    public void onPreviewChanged(int select, int sum, boolean visible) {
        if (visible) {
            this.tvTitle.setText((CharSequence)(select + "/" + sum));
        } else {
            this.tvTitle.setText((CharSequence)this.config.title);
        }
    }

    private void crop(String imagePath) {
        File file = new File(FileUtils.createRootPath((Context)this) + "/" + System.currentTimeMillis() + ".jpg");
        this.cropImagePath = file.getAbsolutePath();
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(this.getImageContentUri(new File(imagePath)), "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", this.config.aspectX);
        intent.putExtra("aspectY", this.config.aspectY);
        intent.putExtra("outputX", this.config.outputX);
        intent.putExtra("outputY", this.config.outputY);
        intent.putExtra("scale", true);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString());
        intent.putExtra("noFaceDetection", true);
        this.startActivityForResult(intent, 1);
    }

    public Uri getImageContentUri(File imageFile) {
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        if (imageFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            return this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return null;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            Constant.imageList.add(this.cropImagePath);
            this.config.multiSelect = false;
            this.exit();
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void exit() {
        Intent intent = new Intent();
        this.result.clear();
        this.result.addAll(Constant.imageList);
        intent.putStringArrayListExtra(INTENT_RESULT, this.result);
        this.setResult(-1, intent);
        if (!this.config.multiSelect) {
            Constant.imageList.clear();
        }
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length >= 1 && grantResults[0] == 0) {
                    this.getSupportFragmentManager().beginTransaction().add(R.id.fmImageList, (Fragment)ImgSelFragment.instance(), null).commitAllowingStateLoss();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.permission_storage_denied), (int)0).show();
                break;
            }
        }
    }

    public void onBackPressed() {
        if (this.fragment == null || !this.fragment.hidePreview()) {
            Constant.imageList.clear();
            super.onBackPressed();
        }
    }
}

