/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.common.OnItemClickListener;
import java.util.List;

public class PreviewAdapter
extends PagerAdapter {
    private Activity activity;
    private List<Image> images;
    private ImgSelConfig config;
    private OnItemClickListener listener;

    public PreviewAdapter(Activity activity, List<Image> images, ImgSelConfig config) {
        this.activity = activity;
        this.images = images;
        this.config = config;
    }

    public int getCount() {
        if (this.config.needCamera) {
            return this.images.size() - 1;
        }
        return this.images.size();
    }

    public View instantiateItem(ViewGroup container, final int position) {
        View root = View.inflate((Context)this.activity, (int)R.layout.item_pager_img_sel, null);
        ImageView photoView = (ImageView)root.findViewById(R.id.ivImage);
        final ImageView ivChecked = (ImageView)root.findViewById(R.id.ivPhotoCheaked);
        if (this.config.multiSelect) {
            ivChecked.setVisibility(0);
            final Image image = this.images.get(this.config.needCamera ? position + 1 : position);
            if (Constant.imageList.contains(image.path)) {
                ivChecked.setImageResource(R.drawable.ic_checked);
            } else {
                ivChecked.setImageResource(R.drawable.ic_uncheck);
            }
            ivChecked.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int ret;
                    if (PreviewAdapter.this.listener != null && (ret = PreviewAdapter.this.listener.onCheckedClick(position, image)) == 1) {
                        if (Constant.imageList.contains(image.path)) {
                            ivChecked.setImageResource(R.drawable.ic_checked);
                        } else {
                            ivChecked.setImageResource(R.drawable.ic_uncheck);
                        }
                    }
                }
            });
            photoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PreviewAdapter.this.listener != null) {
                        PreviewAdapter.this.listener.onImageClick(position, (Image)PreviewAdapter.this.images.get(position));
                    }
                }
            });
        } else {
            ivChecked.setVisibility(8);
        }
        container.addView(root, -1, -1);
        this.displayImage(photoView, this.images.get((int)(this.config.needCamera ? position + 1 : position)).path);
        return root;
    }

    private void displayImage(ImageView photoView, String path) {
        this.config.loader.displayImage((Context)this.activity, path, photoView);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public void setListener(OnItemClickListener listener) {
        this.listener = listener;
    }
}

