/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.yuyh.easyadapter.recyclerview.EasyRVAdapter;
import com.yuyh.easyadapter.recyclerview.EasyRVHolder;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.common.OnItemClickListener;
import java.util.List;

public class ImageListAdapter
extends EasyRVAdapter<Image> {
    private boolean showCamera;
    private boolean mutiSelect;
    private ImgSelConfig config;
    private Context context;
    private OnItemClickListener listener;

    public ImageListAdapter(Context context, List<Image> list, ImgSelConfig config) {
        super(context, list, new int[]{R.layout.item_img_sel, R.layout.item_img_sel_take_photo});
        this.context = context;
        this.config = config;
    }

    protected void onBindData(final EasyRVHolder viewHolder, final int position, final Image item) {
        if (position == 0 && this.showCamera) {
            ImageView iv = (ImageView)viewHolder.getView(R.id.ivTakePhoto);
            iv.setImageResource(R.drawable.ic_take_photo);
            iv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ImageListAdapter.this.listener != null) {
                        ImageListAdapter.this.listener.onImageClick(position, item);
                    }
                }
            });
            return;
        }
        if (this.mutiSelect) {
            viewHolder.getView(R.id.ivPhotoCheaked).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int ret;
                    if (ImageListAdapter.this.listener != null && (ret = ImageListAdapter.this.listener.onCheckedClick(position, item)) == 1) {
                        if (Constant.imageList.contains(item.path)) {
                            viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_checked);
                        } else {
                            viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_uncheck);
                        }
                    }
                }
            });
        }
        viewHolder.setOnItemViewClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageListAdapter.this.listener != null) {
                    ImageListAdapter.this.listener.onImageClick(position, item);
                }
            }
        });
        ImageView iv = (ImageView)viewHolder.getView(R.id.ivImage);
        this.config.loader.displayImage(this.context, item.path, iv);
        if (this.mutiSelect) {
            viewHolder.setVisible(R.id.ivPhotoCheaked, true);
            if (Constant.imageList.contains(item.path)) {
                viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_checked);
            } else {
                viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_uncheck);
            }
        } else {
            viewHolder.setVisible(R.id.ivPhotoCheaked, false);
        }
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public void setMutiSelect(boolean mutiSelect) {
        this.mutiSelect = mutiSelect;
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.showCamera) {
            return 1;
        }
        return 0;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }
}

