/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import com.yuyh.library.imgsel.utils.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;

public class FileUtils {
    private static final String TAG = FileUtils.class.getSimpleName();

    public static String createRootPath(Context context) {
        String cacheRootPath = "";
        cacheRootPath = FileUtils.isSdCardAvailable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return cacheRootPath;
    }

    public static boolean isSdCardAvailable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String createDir(String dirPath) {
        try {
            File file = new File(dirPath);
            if (file.getParentFile().exists()) {
                LogUtils.i("----- \u521b\u5efa\u6587\u4ef6\u5939" + file.getAbsolutePath());
                file.mkdir();
                return file.getAbsolutePath();
            }
            FileUtils.createDir(file.getParentFile().getAbsolutePath());
            LogUtils.i("----- \u521b\u5efa\u6587\u4ef6\u5939" + file.getAbsolutePath());
            file.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dirPath;
    }

    public static String createFile(File file) {
        try {
            if (file.getParentFile().exists()) {
                LogUtils.i("----- \u521b\u5efa\u6587\u4ef6" + file.getAbsolutePath());
                file.createNewFile();
                return file.getAbsolutePath();
            }
            FileUtils.createDir(file.getParentFile().getAbsolutePath());
            file.createNewFile();
            LogUtils.i("----- \u521b\u5efa\u6587\u4ef6" + file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getImageCachePath(String path) {
        return FileUtils.createDir(path);
    }

    public static String getImageCachePath(Context context) {
        String path = FileUtils.createDir(FileUtils.createRootPath(context) + File.separator + "img" + File.separator);
        return path;
    }

    public static String getImageCropCachePath(Context context) {
        String path = FileUtils.createDir(FileUtils.createRootPath(context) + File.separator + "imgCrop" + File.separator);
        return path;
    }

    public static void writeFileSdcard(String filePath, String content, boolean isAppend) {
        try {
            FileOutputStream fout = new FileOutputStream(filePath, isAppend);
            byte[] bytes = content.getBytes();
            fout.write(bytes);
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static InputStream openAssetFile(Context context, String fileName) {
        AssetManager am = context.getAssets();
        InputStream is = null;
        try {
            is = am.open(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public static String getFileFromRaw(Context context, int resId) {
        if (context == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        try {
            String line;
            InputStreamReader in = new InputStreamReader(context.getResources().openRawResource(resId));
            BufferedReader br = new BufferedReader(in);
            while ((line = br.readLine()) != null) {
                s.append(line);
            }
            return s.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileChannelCopy(File src, File desc) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        try {
            fi = new FileInputStream(src);
            fo = new FileOutputStream(desc);
            FileChannel in = fi.getChannel();
            FileChannel out = fo.getChannel();
            in.transferTo(0L, in.size(), out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fo != null) {
                    fo.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String formatFileSizeToString(long fileLen) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileLen < 1024L ? df.format((double)fileLen) + "B" : (fileLen < 0x100000L ? df.format((double)fileLen / 1024.0) + "K" : (fileLen < 0x40000000L ? df.format((double)fileLen / 1048576.0) + "M" : df.format((double)fileLen / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static boolean deleteFile(File file) throws IOException {
        return FileUtils.deleteFileOrDirectory(file);
    }

    public static boolean deleteFileOrDirectory(File file) throws IOException {
        try {
            if (file != null && file.isFile()) {
                return file.delete();
            }
            if (file != null && file.isDirectory()) {
                File[] childFiles = file.listFiles();
                if (childFiles == null || childFiles.length == 0) {
                    return file.delete();
                }
                for (int i = 0; i < childFiles.length; ++i) {
                    FileUtils.deleteFileOrDirectory(childFiles[i]);
                }
                return file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static String getFileOutputString(String path) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(path), 8192);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append("\n").append(line);
            }
            bufferedReader.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

