/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.yuyh.easyadapter.abslistview.EasyLVAdapter;
import com.yuyh.easyadapter.abslistview.EasyLVHolder;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.bean.Folder;
import com.yuyh.library.imgsel.common.OnFolderChangeListener;
import java.util.List;

public class FolderListAdapter
extends EasyLVAdapter<Folder> {
    private Context context;
    private List<Folder> folderList;
    private ImgSelConfig config;
    private int selected = 0;
    private OnFolderChangeListener listener;

    public FolderListAdapter(Context context, List<Folder> folderList, ImgSelConfig config) {
        super(context, folderList, new int[]{R.layout.item_img_sel_folder});
        this.context = context;
        this.folderList = folderList;
        this.config = config;
    }

    public void convert(EasyLVHolder holder, final int position, Folder folder) {
        if (position == 0) {
            holder.setText(R.id.tvFolderName, "\u6240\u6709\u56fe\u7247").setText(R.id.tvImageNum, "\u5171" + this.getTotalImageSize() + "\u5f20");
            ImageView ivFolder = (ImageView)holder.getView(R.id.ivFolder);
            if (this.folderList.size() > 0) {
                this.config.loader.displayImage(this.context, folder.cover.path, ivFolder);
            }
        } else {
            holder.setText(R.id.tvFolderName, folder.name).setText(R.id.tvImageNum, "\u5171" + folder.images.size() + "\u5f20");
            ImageView ivFolder = (ImageView)holder.getView(R.id.ivFolder);
            if (this.folderList.size() > 0) {
                this.config.loader.displayImage(this.context, folder.cover.path, ivFolder);
            }
        }
        if (this.selected == position) {
            holder.setVisible(R.id.indicator, true);
        } else {
            holder.setVisible(R.id.indicator, false);
        }
        holder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FolderListAdapter.this.setSelectIndex(position);
            }
        });
    }

    public void setData(List<Folder> folders) {
        this.folderList.clear();
        if (folders != null && folders.size() > 0) {
            this.folderList.addAll(folders);
        }
        this.notifyDataSetChanged();
    }

    private int getTotalImageSize() {
        int result = 0;
        if (this.folderList != null && this.folderList.size() > 0) {
            for (Folder folder : this.folderList) {
                result += folder.images.size();
            }
        }
        return result;
    }

    public void setSelectIndex(int position) {
        if (this.selected == position) {
            return;
        }
        if (this.listener != null) {
            this.listener.onChange(position, this.folderList.get(position));
        }
        this.selected = position;
        this.notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return this.selected;
    }

    public void setOnFloderChangeListener(OnFolderChangeListener listener) {
        this.listener = listener;
    }
}

