/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.ListPopupWindow;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.adapter.FolderListAdapter;
import com.yuyh.library.imgsel.adapter.ImageListAdapter;
import com.yuyh.library.imgsel.adapter.PreviewAdapter;
import com.yuyh.library.imgsel.bean.Folder;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.common.Callback;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.common.OnFolderChangeListener;
import com.yuyh.library.imgsel.common.OnItemClickListener;
import com.yuyh.library.imgsel.utils.FileUtils;
import com.yuyh.library.imgsel.utils.LogUtils;
import com.yuyh.library.imgsel.widget.CustomViewPager;
import com.yuyh.library.imgsel.widget.DividerGridItemDecoration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImgSelFragment
extends Fragment
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private RecyclerView rvImageList;
    private Button btnAlbumSelected;
    private View rlBottom;
    private CustomViewPager viewPager;
    private ImgSelConfig config;
    private Callback callback;
    private List<Folder> folderList = new ArrayList<Folder>();
    private List<Image> imageList = new ArrayList<Image>();
    private ListPopupWindow folderPopupWindow;
    private ImageListAdapter imageListAdapter;
    private FolderListAdapter folderListAdapter;
    private PreviewAdapter previewAdapter;
    private boolean hasFolderGened = false;
    private static final int LOADER_ALL = 0;
    private static final int LOADER_CATEGORY = 1;
    private static final int REQUEST_CAMERA = 5;
    private File tempFile;
    private LoaderManager.LoaderCallbacks<Cursor> mLoaderCallback = new LoaderManager.LoaderCallbacks<Cursor>(){
        private final String[] IMAGE_PROJECTION = new String[]{"_data", "_display_name", "date_added", "_id"};

        public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
            if (id2 == 0) {
                CursorLoader cursorLoader = new CursorLoader((Context)ImgSelFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, null, null, this.IMAGE_PROJECTION[2] + " DESC");
                return cursorLoader;
            }
            if (id2 == 1) {
                CursorLoader cursorLoader = new CursorLoader((Context)ImgSelFragment.this.getActivity(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.IMAGE_PROJECTION, this.IMAGE_PROJECTION[0] + " like '%" + args.getString("path") + "%'", null, this.IMAGE_PROJECTION[2] + " DESC");
                return cursorLoader;
            }
            return null;
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
            int count;
            if (data != null && (count = data.getCount()) > 0) {
                ArrayList<Image> tempImageList = new ArrayList<Image>();
                data.moveToFirst();
                do {
                    String path = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[0]));
                    String name = data.getString(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[1]));
                    long dateTime = data.getLong(data.getColumnIndexOrThrow(this.IMAGE_PROJECTION[2]));
                    Image image = new Image(path, name, dateTime);
                    if (!image.path.endsWith("gif")) {
                        tempImageList.add(image);
                    }
                    if (ImgSelFragment.this.hasFolderGened) continue;
                    File imageFile = new File(path);
                    File folderFile = imageFile.getParentFile();
                    Folder folder = new Folder();
                    folder.name = folderFile.getName();
                    folder.path = folderFile.getAbsolutePath();
                    folder.cover = image;
                    if (!ImgSelFragment.this.folderList.contains(folder)) {
                        ArrayList<Image> imageList = new ArrayList<Image>();
                        imageList.add(image);
                        folder.images = imageList;
                        ImgSelFragment.this.folderList.add(folder);
                        continue;
                    }
                    Folder f = (Folder)ImgSelFragment.this.folderList.get(ImgSelFragment.this.folderList.indexOf(folder));
                    f.images.add(image);
                } while (data.moveToNext());
                ImgSelFragment.this.imageList.clear();
                if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                    ImgSelFragment.this.imageList.add(new Image());
                }
                ImgSelFragment.this.imageList.addAll(tempImageList);
                ImgSelFragment.this.imageListAdapter.notifyDataSetChanged();
                if (Constant.imageList == null || Constant.imageList.size() > 0) {
                    // empty if block
                }
                ImgSelFragment.this.folderListAdapter.notifyDataSetChanged();
                ImgSelFragment.this.hasFolderGened = true;
            }
        }

        public void onLoaderReset(Loader<Cursor> loader) {
        }
    };

    public static ImgSelFragment instance() {
        ImgSelFragment fragment = new ImgSelFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_img_sel, container, false);
        this.rvImageList = (RecyclerView)view.findViewById(R.id.rvImageList);
        this.btnAlbumSelected = (Button)view.findViewById(R.id.btnAlbumSelected);
        this.btnAlbumSelected.setOnClickListener((View.OnClickListener)this);
        this.rlBottom = view.findViewById(R.id.rlBottom);
        this.viewPager = (CustomViewPager)view.findViewById(R.id.viewPager);
        this.viewPager.addOnPageChangeListener(this);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.config = Constant.config;
        try {
            this.callback = (Callback)this.getActivity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rvImageList.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.rvImageList.getContext(), 3));
        this.rvImageList.addItemDecoration((RecyclerView.ItemDecoration)new DividerGridItemDecoration(this.rvImageList.getContext()));
        if (this.config.needCamera) {
            this.imageList.add(new Image());
        }
        this.imageListAdapter = new ImageListAdapter((Context)this.getActivity(), this.imageList, this.config);
        this.imageListAdapter.setShowCamera(this.config.needCamera);
        this.imageListAdapter.setMutiSelect(this.config.multiSelect);
        this.rvImageList.setAdapter((RecyclerView.Adapter)this.imageListAdapter);
        this.imageListAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public int onCheckedClick(int position, Image image) {
                return ImgSelFragment.this.checkedImage(position, image);
            }

            @Override
            public void onImageClick(int position, Image image) {
                if (((ImgSelFragment)ImgSelFragment.this).config.needCamera && position == 0) {
                    ImgSelFragment.this.showCameraAction();
                } else if (((ImgSelFragment)ImgSelFragment.this).config.multiSelect) {
                    ImgSelFragment.this.viewPager.setAdapter(ImgSelFragment.this.previewAdapter = new PreviewAdapter((Activity)ImgSelFragment.this.getActivity(), ImgSelFragment.this.imageList, ImgSelFragment.this.config));
                    ImgSelFragment.this.previewAdapter.setListener(new OnItemClickListener(){

                        @Override
                        public int onCheckedClick(int position, Image image) {
                            return ImgSelFragment.this.checkedImage(position, image);
                        }

                        @Override
                        public void onImageClick(int position, Image image) {
                            ImgSelFragment.this.hidePreview();
                        }
                    });
                    if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                        ImgSelFragment.this.callback.onPreviewChanged(position, ImgSelFragment.this.imageList.size() - 1, true);
                    } else {
                        ImgSelFragment.this.callback.onPreviewChanged(position + 1, ImgSelFragment.this.imageList.size(), true);
                    }
                    ImgSelFragment.this.viewPager.setCurrentItem(((ImgSelFragment)ImgSelFragment.this).config.needCamera ? position - 1 : position);
                    ImgSelFragment.this.viewPager.setVisibility(0);
                } else if (ImgSelFragment.this.callback != null) {
                    ImgSelFragment.this.callback.onSingleImageSelected(image.path);
                }
            }
        });
        this.folderListAdapter = new FolderListAdapter((Context)this.getActivity(), this.folderList, this.config);
        this.getActivity().getSupportLoaderManager().initLoader(0, null, this.mLoaderCallback);
    }

    private int checkedImage(int position, Image image) {
        if (image != null) {
            if (Constant.imageList.contains(image.path)) {
                Constant.imageList.remove(image.path);
                if (this.callback != null) {
                    this.callback.onImageUnselected(image.path);
                }
            } else {
                if (this.config.maxNum <= Constant.imageList.size()) {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)String.format(this.getString(R.string.maxnum), this.config.maxNum), (int)0).show();
                    return 0;
                }
                Constant.imageList.add(image.path);
                if (this.callback != null) {
                    this.callback.onImageSelected(image.path);
                }
            }
            return 1;
        }
        return 0;
    }

    private void createPopupFolderList(int width, int height) {
        this.folderPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.folderPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.folderPopupWindow.setAdapter((ListAdapter)this.folderListAdapter);
        this.folderPopupWindow.setContentWidth(width);
        this.folderPopupWindow.setWidth(width);
        this.folderPopupWindow.setHeight(height);
        this.folderPopupWindow.setAnchorView(this.rlBottom);
        this.folderPopupWindow.setModal(true);
        this.folderListAdapter.setOnFloderChangeListener(new OnFolderChangeListener(){

            @Override
            public void onChange(int position, Folder folder) {
                ImgSelFragment.this.folderPopupWindow.dismiss();
                if (position == 0) {
                    ImgSelFragment.this.getActivity().getSupportLoaderManager().restartLoader(0, null, ImgSelFragment.this.mLoaderCallback);
                    ImgSelFragment.this.btnAlbumSelected.setText((CharSequence)ImgSelFragment.this.getString(R.string.all_images));
                } else {
                    ImgSelFragment.this.imageList.clear();
                    if (((ImgSelFragment)ImgSelFragment.this).config.needCamera) {
                        ImgSelFragment.this.imageList.add(new Image());
                    }
                    ImgSelFragment.this.imageList.addAll(folder.images);
                    ImgSelFragment.this.imageListAdapter.notifyDataSetChanged();
                    ImgSelFragment.this.btnAlbumSelected.setText((CharSequence)folder.name);
                }
            }
        });
    }

    public void onClick(View v) {
        if (v.getId() == this.btnAlbumSelected.getId()) {
            if (this.folderPopupWindow == null) {
                WindowManager wm = this.getActivity().getWindowManager();
                int width = wm.getDefaultDisplay().getWidth();
                this.createPopupFolderList(width / 3 * 2, width / 3 * 2);
            }
            if (this.folderPopupWindow.isShowing()) {
                this.folderPopupWindow.dismiss();
            } else {
                this.folderPopupWindow.show();
                int index = this.folderListAdapter.getSelectIndex();
                index = index == 0 ? index : index - 1;
                this.folderPopupWindow.getListView().setSelection(index);
            }
        }
    }

    private void showCameraAction() {
        if (this.config.maxNum <= Constant.imageList.size()) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)String.format(this.getString(R.string.maxnum), this.config.maxNum), (int)0).show();
            return;
        }
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.tempFile = new File(FileUtils.createRootPath((Context)this.getActivity()) + "/" + System.currentTimeMillis() + ".jpg");
            LogUtils.e(this.tempFile.getAbsolutePath());
            FileUtils.createFile(this.tempFile);
            cameraIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.tempFile));
            this.startActivityForResult(cameraIntent, 5);
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(R.string.open_camera_failure), (int)0).show();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 5) {
            if (resultCode == -1) {
                if (this.tempFile != null && this.callback != null) {
                    this.callback.onCameraShot(this.tempFile);
                }
            } else if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (this.config.needCamera) {
            this.callback.onPreviewChanged(position + 1, this.imageList.size() - 1, true);
        } else {
            this.callback.onPreviewChanged(position + 1, this.imageList.size(), true);
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public boolean hidePreview() {
        if (this.viewPager.getVisibility() == 0) {
            this.viewPager.setVisibility(8);
            this.callback.onPreviewChanged(0, 0, false);
            this.imageListAdapter.notifyDataSetChanged();
            return true;
        }
        return false;
    }
}

