/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel.adapter;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yuyh.easyadapter.recyclerview.EasyRVAdapter;
import com.yuyh.easyadapter.recyclerview.EasyRVHolder;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.bean.Image;
import com.yuyh.library.imgsel.common.OnItemClickListener;
import java.util.ArrayList;
import java.util.List;

public class ImageListAdapter
extends EasyRVAdapter<Image> {
    private boolean showCamera;
    private boolean mutiSelect;
    private ImgSelConfig config;
    private Context context;
    private List<Image> selectedImageList = new ArrayList<Image>();
    private OnItemClickListener listener;

    public ImageListAdapter(Context context, List<Image> list, ImgSelConfig config) {
        super(context, list, new int[]{R.layout.item_img_sel, R.layout.item_img_sel_take_photo});
        this.context = context;
        this.config = config;
    }

    protected void onBindData(EasyRVHolder viewHolder, final int position, final Image item) {
        viewHolder.getItemView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageListAdapter.this.listener != null) {
                    ImageListAdapter.this.listener.onClick(position, item);
                }
            }
        });
        if (position == 0 && this.showCamera) {
            ImageView iv = (ImageView)viewHolder.getView(R.id.ivTakePhoto);
            iv.setImageResource(R.drawable.ic_take_photo);
            return;
        }
        final ImageView iv = (ImageView)viewHolder.getView(R.id.ivImage);
        this.config.loader.displayImage(this.context, item.path, iv);
        iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    iv.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    iv.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)iv.getLayoutParams();
                params.height = params.width;
                iv.setLayoutParams((ViewGroup.LayoutParams)params);
                iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        });
        if (this.mutiSelect) {
            viewHolder.setVisible(R.id.ivPhotoCheaked, true);
            if (this.selectedImageList.contains(item)) {
                viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_checked);
            } else {
                viewHolder.setImageResource(R.id.ivPhotoCheaked, R.drawable.ic_uncheck);
            }
        } else {
            viewHolder.setVisible(R.id.ivPhotoCheaked, false);
        }
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public void setMutiSelect(boolean mutiSelect) {
        this.mutiSelect = mutiSelect;
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.showCamera) {
            return 1;
        }
        return 0;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public void select(Image image) {
        if (this.selectedImageList.contains(image)) {
            this.selectedImageList.remove(image);
        } else {
            this.selectedImageList.add(image);
        }
        this.notifyDataSetChanged();
    }
}

