/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.library.imgsel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.yuyh.library.imgsel.ImgSelConfig;
import com.yuyh.library.imgsel.ImgSelFragment;
import com.yuyh.library.imgsel.R;
import com.yuyh.library.imgsel.common.Callback;
import com.yuyh.library.imgsel.common.Constant;
import com.yuyh.library.imgsel.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;

public class ImgSelActivity
extends FragmentActivity
implements View.OnClickListener,
Callback {
    public static final String INTENT_RESULT = "result";
    private static final int IMAGE_CROP_CODE = 1;
    private ImgSelConfig config;
    private RelativeLayout rlTitleBar;
    private TextView tvTitle;
    private Button btnConfirm;
    private String cropImagePath;
    private ArrayList<String> result = new ArrayList();

    public static void startActivity(Activity activity, ImgSelConfig config, int RequestCode) {
        Intent intent = new Intent((Context)activity, ImgSelActivity.class);
        Constant.config = config;
        activity.startActivityForResult(intent, RequestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_img_sel);
        Constant.imageList.clear();
        this.config = Constant.config;
        this.getSupportFragmentManager().beginTransaction().add(R.id.fmImageList, (Fragment)ImgSelFragment.instance(this.config), null).commit();
        this.initView();
        if (!FileUtils.isSdCardAvailable()) {
            Toast.makeText((Context)this, (CharSequence)"SD\u5361\u4e0d\u53ef\u7528", (int)0).show();
        }
    }

    private void initView() {
        this.rlTitleBar = (RelativeLayout)this.findViewById(R.id.rlTitleBar);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.btnConfirm = (Button)this.findViewById(R.id.btnConfirm);
        this.btnConfirm.setOnClickListener((View.OnClickListener)this);
        if (this.config != null) {
            this.rlTitleBar.setBackgroundColor(this.config.titleBgColor);
            this.tvTitle.setTextColor(this.config.titleColor);
            this.tvTitle.setText((CharSequence)this.config.title);
            this.btnConfirm.setBackgroundColor(this.config.btnBgColor);
            this.btnConfirm.setTextColor(this.config.btnTextColor);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnConfirm && Constant.imageList != null && !Constant.imageList.isEmpty()) {
            this.exit();
        }
    }

    @Override
    public void onSingleImageSelected(String path) {
        if (this.config.needCrop) {
            this.crop(path);
        } else {
            Constant.imageList.add(path);
            this.exit();
        }
    }

    @Override
    public void onImageSelected(String path) {
        this.btnConfirm.setText((CharSequence)("\u786e\u5b9a(" + Constant.imageList.size() + "/" + this.config.maxNum + ")"));
    }

    @Override
    public void onImageUnselected(String path) {
        this.btnConfirm.setText((CharSequence)("\u786e\u5b9a(" + Constant.imageList.size() + "/" + this.config.maxNum + ")"));
    }

    @Override
    public void onCameraShot(File imageFile) {
        if (imageFile != null) {
            if (this.config.needCrop) {
                this.crop(imageFile.getAbsolutePath());
            } else {
                Constant.imageList.add(imageFile.getAbsolutePath());
                this.exit();
            }
        }
    }

    private void crop(String imagePath) {
        File file = new File(FileUtils.createRootPath((Context)this) + "/" + System.currentTimeMillis() + ".jpg");
        this.cropImagePath = file.getAbsolutePath();
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(Uri.fromFile((File)new File(imagePath)), "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", this.config.aspectX);
        intent.putExtra("aspectY", this.config.aspectY);
        intent.putExtra("outputX", this.config.outputX);
        intent.putExtra("outputY", this.config.outputY);
        intent.putExtra("return-data", false);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        this.startActivityForResult(intent, 1);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            Constant.imageList.add(this.cropImagePath);
            this.exit();
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void exit() {
        Intent intent = new Intent();
        this.result.clear();
        this.result.addAll(Constant.imageList);
        intent.putStringArrayListExtra(INTENT_RESULT, this.result);
        this.setResult(-1, intent);
        Constant.imageList.clear();
        this.finish();
    }
}

