/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yuyh.easyadapter.helper.DataHelper;
import com.yuyh.easyadapter.recyclerview.EasyRVHolder;
import java.util.List;

public abstract class EasyRVAdapter<T>
extends RecyclerView.Adapter<EasyRVHolder>
implements DataHelper<T> {
    public static final int TYPE_HEADER = -1;
    public static final int TYPE_FOOTER = -2;
    private View mHeaderView;
    private View mFooterView;
    private int headerViewId = -1;
    private int footerViewId = -2;
    protected Context mContext;
    protected List<T> mList;
    protected int[] layoutIds;
    protected LayoutInflater mLInflater;
    private SparseArray<View> mConvertViews = new SparseArray();

    public EasyRVAdapter(Context context, List<T> list, int ... layoutIds) {
        this.mContext = context;
        this.mList = list;
        this.layoutIds = layoutIds;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public EasyRVHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        EasyRVHolder viewHolder;
        if (this.mHeaderView != null && viewType == -1) {
            return new EasyRVHolder(this.mContext, this.headerViewId, this.mHeaderView);
        }
        if (this.mFooterView != null && viewType == -2) {
            return new EasyRVHolder(this.mContext, this.footerViewId, this.mFooterView);
        }
        if (viewType < 0 || viewType > this.layoutIds.length) {
            throw new ArrayIndexOutOfBoundsException("layoutIndex");
        }
        if (this.layoutIds.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.layoutIds[viewType];
        View view = (View)this.mConvertViews.get(layoutId);
        if (view == null) {
            view = this.mLInflater.inflate(layoutId, parent, false);
        }
        if ((viewHolder = (EasyRVHolder)view.getTag()) == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new EasyRVHolder(this.mContext, layoutId, view);
            return viewHolder;
        }
        return viewHolder;
    }

    public void onBindViewHolder(EasyRVHolder holder, int position) {
        if (this.getItemViewType(position) == -1) {
            return;
        }
        if (this.getItemViewType(position) == -2) {
            return;
        }
        position = this.getPosition(position);
        T item = this.mList.get(position);
        this.onBindData(holder, position, item);
    }

    public int getItemCount() {
        if (this.mHeaderView == null && this.mFooterView == null) {
            return this.mList == null ? 0 : this.mList.size();
        }
        if (this.mHeaderView != null && this.mFooterView != null) {
            return this.mList == null ? 2 : this.mList.size() + 2;
        }
        return this.mList == null ? 1 : this.mList.size() + 1;
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.mHeaderView != null) {
            return -1;
        }
        if (position == this.getItemCount() - 1 && this.mFooterView != null) {
            return -2;
        }
        position = this.getPosition(position);
        return this.getLayoutIndex(position, this.mList.get(position));
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return EasyRVAdapter.this.getItemViewType(position) == -1 || EasyRVAdapter.this.getItemViewType(position) == -2 ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(EasyRVHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(holder.getLayoutPosition() == 0);
        }
    }

    private int getPosition(int position) {
        if (this.mHeaderView != null) {
            --position;
        }
        return position;
    }

    public int getLayoutIndex(int position, T item) {
        return 0;
    }

    public View setHeaderView(int headerViewId) {
        return this.setHeaderView(headerViewId, null);
    }

    public View setHeaderView(int headerViewId, ViewGroup parent) {
        this.mHeaderView = this.mLInflater.inflate(headerViewId, parent, false);
        this.headerViewId = headerViewId;
        this.notifyItemInserted(0);
        return this.mHeaderView;
    }

    public void removeHeaderView() {
        if (this.mHeaderView != null) {
            this.mHeaderView = null;
            this.headerViewId = -1;
            this.notifyItemRemoved(0);
        }
    }

    public View setFooterView(int footerViewId) {
        return this.setFooterView(footerViewId, null);
    }

    public View setFooterView(int footerViewId, ViewGroup parent) {
        this.mFooterView = this.mLInflater.inflate(footerViewId, parent, false);
        this.footerViewId = footerViewId;
        this.notifyItemInserted(this.mList.size());
        return this.mFooterView;
    }

    public void removeFooterView() {
        if (this.mFooterView != null) {
            this.mFooterView = null;
            this.footerViewId = -2;
            this.notifyItemRemoved(this.mList.size() - 1);
        }
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public View getFooterView() {
        return this.mFooterView;
    }

    protected abstract void onBindData(EasyRVHolder var1, int var2, T var3);

    @Override
    public boolean addAll(List<T> list) {
        boolean result = this.mList.addAll(list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addAll(int position, List list) {
        boolean result = this.mList.addAll(position, list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(T data) {
        this.mList.add(data);
        this.notifyDataSetChanged();
    }

    @Override
    public void add(int position, T data) {
        this.mList.add(position, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        return this.mList.contains(data);
    }

    @Override
    public T getData(int index) {
        return this.mList.get(index);
    }

    @Override
    public void modify(T oldData, T newData) {
        this.modify(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void modify(int index, T newData) {
        this.mList.set(index, newData);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void remove(int index) {
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }
}

