/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.abslistview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.yuyh.easyadapter.helper.ViewHelper;

public class EasyLVHolder
implements ViewHelper.AbsListView<EasyLVHolder> {
    private SparseArray<View> mViews = new SparseArray();
    private SparseArray<View> mConvertViews = new SparseArray();
    private View mConvertView;
    protected int mPosition;
    protected int mLayoutId;
    protected Context mContext;

    protected EasyLVHolder(Context context, int position, ViewGroup parent, int layoutId) {
        this.mConvertView = (View)this.mConvertViews.get(layoutId);
        this.mPosition = position;
        this.mContext = context;
        this.mLayoutId = layoutId;
        if (this.mConvertView == null) {
            this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
            this.mConvertViews.put(layoutId, (Object)this.mConvertView);
            this.mConvertView.setTag((Object)this);
        }
    }

    protected EasyLVHolder() {
    }

    public <BVH extends EasyLVHolder> BVH get(Context context, int position, View convertView, ViewGroup parent, int layoutId) {
        if (convertView == null) {
            return (BVH)new EasyLVHolder(context, position, parent, layoutId);
        }
        EasyLVHolder holder = (EasyLVHolder)convertView.getTag();
        if (holder.mLayoutId != layoutId) {
            return (BVH)new EasyLVHolder(context, position, parent, layoutId);
        }
        holder.setPosition(position);
        return (BVH)holder;
    }

    public View getConvertView() {
        return (View)this.mConvertViews.valueAt(0);
    }

    public View getConvertView(int layoutId) {
        return (View)this.mConvertViews.get(layoutId);
    }

    public <V extends View> V getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (V)view;
    }

    public void setPosition(int mPosition) {
        this.mPosition = mPosition;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    @Override
    public EasyLVHolder setText(int viewId, String value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    @Override
    public EasyLVHolder setTextColor(int viewId, int color) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(color);
        return this;
    }

    @Override
    public EasyLVHolder setTextColorRes(int viewId, int colorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(colorRes, null));
        return this;
    }

    @Override
    public EasyLVHolder setImageResource(int viewId, int imgResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imgResId);
        return this;
    }

    @Override
    public EasyLVHolder setBackgroundColor(int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    @Override
    public EasyLVHolder setBackgroundColorRes(int viewId, int colorRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(colorRes);
        return this;
    }

    @Override
    public EasyLVHolder setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    @Override
    public EasyLVHolder setImageDrawableRes(int viewId, int drawableRes) {
        Drawable drawable = this.mContext.getResources().getDrawable(drawableRes, null);
        return this.setImageDrawable(viewId, drawable);
    }

    @Override
    public EasyLVHolder setImageUrl(int viewId, String imgUrl) {
        return this;
    }

    @Override
    public EasyLVHolder setImageBitmap(int viewId, Bitmap imgBitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(imgBitmap);
        return this;
    }

    @Override
    public EasyLVHolder setVisible(int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    @Override
    public EasyLVHolder setVisible(int viewId, int visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible);
        return this;
    }

    @Override
    public EasyLVHolder setTag(int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    @Override
    public EasyLVHolder setTag(int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    @Override
    public EasyLVHolder setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    @Override
    public EasyLVHolder setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    @Override
    public EasyLVHolder setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    @Override
    public EasyLVHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    @Override
    public EasyLVHolder setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }
}

