/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.recyclerview;

import android.content.Context;
import android.view.View;
import com.yuyh.easyadapter.recyclerview.EasyRVAdapter;
import com.yuyh.easyadapter.recyclerview.EasyRVHolder;
import java.util.List;

public class BaseRVAdapter<T>
extends EasyRVAdapter<T> {
    private ItemClick ic;
    private OnItemClick oic;
    private OnItemLongClick oil;

    public BaseRVAdapter(Context context, List<T> list, int ... layoutIds) {
        super(context, list, layoutIds);
    }

    @Override
    protected void onBindData(EasyRVHolder viewHolder, final int position, final T item) {
        viewHolder.setOnItemViewClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseRVAdapter.this.ic != null) {
                    BaseRVAdapter.this.ic.onItemClick(v, v.getId(), position, item);
                }
                if (BaseRVAdapter.this.oic != null) {
                    BaseRVAdapter.this.oic.onItemClick(v, v.getId(), position, item);
                }
            }
        });
        viewHolder.setOnItemViewLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (BaseRVAdapter.this.ic != null) {
                    BaseRVAdapter.this.ic.onItemLongClick(v, v.getId(), position, item);
                }
                if (BaseRVAdapter.this.oil != null) {
                    BaseRVAdapter.this.oil.onItemLongClick(v, v.getId(), position, item);
                }
                return false;
            }
        });
    }

    public void setClick(ItemClick<T> ic) {
        this.ic = ic;
    }

    public void setClick(OnItemClick<T> oic) {
        this.oic = oic;
    }

    public void setClick(OnItemLongClick<T> oil) {
        this.oil = oil;
    }

    public static interface OnItemLongClick<T> {
        public void onItemLongClick(View var1, int var2, int var3, T var4);
    }

    public static interface OnItemClick<T> {
        public void onItemClick(View var1, int var2, int var3, T var4);
    }

    public static interface ItemClick<T> {
        public void onItemClick(View var1, int var2, int var3, T var4);

        public void onItemLongClick(View var1, int var2, int var3, T var4);
    }
}

