/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.abslistview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.yuyh.easyadapter.abslistview.EasyLVHolder;
import com.yuyh.easyadapter.helper.DataHelper;
import java.util.List;

public abstract class EasyLVAdapter<T>
extends BaseAdapter
implements DataHelper<T> {
    protected Context mContext;
    protected List<T> mList;
    protected int[] layoutIds;
    protected LayoutInflater mLInflater;
    protected EasyLVHolder holder = new EasyLVHolder();

    public EasyLVAdapter(Context context, List<T> list, int ... layoutIds) {
        this.mContext = context;
        this.mList = list;
        this.layoutIds = layoutIds;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public EasyLVAdapter(Context context, List<T> list) {
        this.mContext = context;
        this.mList = list;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public int getCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList == null ? null : this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int layoutId = this.getViewCheckLayoutId(position);
        this.holder = this.holder.get(this.mContext, position, convertView, parent, layoutId);
        this.convert(this.holder, position, this.mList.get(position));
        return this.holder.getConvertView(layoutId);
    }

    private int getViewCheckLayoutId(int position) {
        int layoutId = this.layoutIds == null || this.layoutIds.length == 0 ? this.getLayoutId(position, this.mList.get(position)) : this.layoutIds[this.getLayoutIndex(position, this.mList.get(position))];
        return layoutId;
    }

    public int getLayoutId(int position, T item) {
        return 0;
    }

    public int getLayoutIndex(int position, T item) {
        return 0;
    }

    public abstract void convert(EasyLVHolder var1, int var2, T var3);

    @Override
    public boolean addAll(List<T> list) {
        boolean result = this.mList.addAll(list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addAll(int position, List list) {
        boolean result = this.mList.addAll(position, list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(T data) {
        this.mList.add(data);
        this.notifyDataSetChanged();
    }

    @Override
    public void add(int position, T data) {
        this.mList.add(position, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        return this.mList.contains(data);
    }

    @Override
    public T getData(int index) {
        return this.mList.get(index);
    }

    @Override
    public void modify(T oldData, T newData) {
        this.modify(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void modify(int index, T newData) {
        this.mList.set(index, newData);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void remove(int index) {
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }
}

