/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.recyclerview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.yuyh.easyadapter.helper.ViewHelper;

public class EasyRVHolder
extends RecyclerView.ViewHolder
implements ViewHelper.RecyclerView<EasyRVHolder> {
    private SparseArray<View> mViews = new SparseArray();
    private View mConvertView;
    private int mLayoutId;
    protected Context mContext;

    public EasyRVHolder(Context context, int layoutId, View itemView) {
        super(itemView);
        this.mContext = context;
        this.mLayoutId = layoutId;
        this.mConvertView = itemView;
        this.mConvertView.setTag((Object)this);
    }

    public <V extends View> V getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (V)view;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    public View getItemView() {
        return this.mConvertView;
    }

    public EasyRVHolder setOnItemViewClickListener(View.OnClickListener listener) {
        this.mConvertView.setOnClickListener(listener);
        return this;
    }

    @Override
    public EasyRVHolder setText(int viewId, String value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    @Override
    public EasyRVHolder setTextColor(int viewId, int color) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(color);
        return this;
    }

    @Override
    public EasyRVHolder setTextColorRes(int viewId, int colorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(colorRes, null));
        return this;
    }

    @Override
    public EasyRVHolder setImageResource(int viewId, int imgResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imgResId);
        return this;
    }

    @Override
    public EasyRVHolder setBackgroundColor(int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    @Override
    public EasyRVHolder setBackgroundColorRes(int viewId, int colorRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(colorRes);
        return this;
    }

    @Override
    public EasyRVHolder setImageDrawable(int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    @Override
    public EasyRVHolder setImageDrawableRes(int viewId, int drawableRes) {
        Drawable drawable = this.mContext.getResources().getDrawable(drawableRes, null);
        return this.setImageDrawable(viewId, drawable);
    }

    @Override
    public EasyRVHolder setImageUrl(int viewId, String imgUrl) {
        return this;
    }

    @Override
    public EasyRVHolder setImageBitmap(int viewId, Bitmap imgBitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(imgBitmap);
        return this;
    }

    @Override
    public EasyRVHolder setVisible(int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    @Override
    public EasyRVHolder setVisible(int viewId, int visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible);
        return this;
    }

    @Override
    public EasyRVHolder setTag(int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    @Override
    public EasyRVHolder setTag(int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    @Override
    public EasyRVHolder setChecked(int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    @Override
    public EasyRVHolder setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    @Override
    public EasyRVHolder setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    @Override
    public EasyRVHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    @Override
    public EasyRVHolder setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }
}

