/*
 * Decompiled with CFR 0.152.
 */
package com.yuyh.easyadapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yuyh.easyadapter.helper.DataHelper;
import com.yuyh.easyadapter.recyclerview.EasyRVHolder;
import java.util.List;

public abstract class EasyRVAdapter<T>
extends RecyclerView.Adapter<EasyRVHolder>
implements DataHelper<T> {
    protected Context mContext;
    protected List<T> mList;
    protected int[] layoutIds;
    protected LayoutInflater mLInflater;
    private SparseArray<View> mConvertViews = new SparseArray();

    public EasyRVAdapter(Context context, List<T> list, int ... layoutIds) {
        this.mContext = context;
        this.mList = list;
        this.layoutIds = layoutIds;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public EasyRVHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        EasyRVHolder viewHolder;
        if (viewType < 0 || viewType > this.layoutIds.length) {
            throw new ArrayIndexOutOfBoundsException("layoutIndex");
        }
        if (this.layoutIds.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.layoutIds[viewType];
        View view = (View)this.mConvertViews.get(layoutId);
        if (view == null) {
            view = this.mLInflater.inflate(layoutId, parent, false);
        }
        if ((viewHolder = (EasyRVHolder)view.getTag()) == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new EasyRVHolder(this.mContext, layoutId, view);
            return viewHolder;
        }
        return viewHolder;
    }

    public void onBindViewHolder(EasyRVHolder holder, int position) {
        T item = this.mList.get(position);
        this.onBindData(holder, position, item);
    }

    public int getItemCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public int getItemViewType(int position) {
        return this.getLayoutIndex(position, this.mList.get(position));
    }

    public int getLayoutIndex(int position, T item) {
        return 0;
    }

    protected abstract void onBindData(EasyRVHolder var1, int var2, T var3);

    @Override
    public boolean addAll(List<T> list) {
        boolean result = this.mList.addAll(list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addAll(int position, List list) {
        boolean result = this.mList.addAll(position, list);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(T data) {
        this.mList.add(data);
        this.notifyDataSetChanged();
    }

    @Override
    public void add(int position, T data) {
        this.mList.add(position, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        return this.mList.contains(data);
    }

    @Override
    public T getData(int index) {
        return this.mList.get(index);
    }

    @Override
    public void modify(T oldData, T newData) {
        this.modify(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void modify(int index, T newData) {
        this.mList.set(index, newData);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void remove(int index) {
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }
}

