/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.rxmedialoader.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import com.yuyakaido.android.rxmedialoader.entity.Album;
import com.yuyakaido.android.rxmedialoader.entity.Media;
import com.yuyakaido.android.rxmedialoader.util.MediaUtil;
import java.util.List;

public class PhotoLoader
implements LoaderManager.LoaderCallbacks<Cursor> {
    private final Context context;
    private final List<Album> albums;
    private final Callback callback;

    public PhotoLoader(Context context, LoaderManager loaderManager, List<Album> albums, Callback callback) {
        this.context = context;
        this.albums = albums;
        this.callback = callback;
        loaderManager.restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        return InternalPhotoLoader.newInstance(this.context, this.albums);
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        this.callback.onPhotoLoaded(this.albums);
    }

    private static class InternalPhotoLoader
    extends CursorLoader {
        private static final String[] PROJECTION = new String[]{"_id", "bucket_id", "datetaken"};
        private static final String ORDER_BY = "datetaken DESC";
        private final List<Album> albums;

        public static CursorLoader newInstance(Context context, List<Album> albums) {
            return new InternalPhotoLoader(context, albums, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, PROJECTION, null, null, ORDER_BY);
        }

        private InternalPhotoLoader(Context context, List<Album> albums, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
            super(context, uri, projection, selection, selectionArgs, sortOrder);
            this.albums = albums;
        }

        public Cursor loadInBackground() {
            Cursor cursor = super.loadInBackground();
            if (cursor.moveToFirst()) {
                do {
                    Media media = MediaUtil.photo(cursor);
                    String id = cursor.getString(cursor.getColumnIndex("bucket_id"));
                    Album album = this.getAlbum(id);
                    if (album.medias.isEmpty()) {
                        album.cover = media;
                    }
                    album.medias.add(media);
                } while (cursor.moveToNext());
            }
            return cursor;
        }

        private Album getAlbum(String id) {
            for (Album album : this.albums) {
                if (!album.folder.id.equals(id)) continue;
                return album;
            }
            return null;
        }
    }

    public static interface Callback {
        public void onPhotoLoaded(List<Album> var1);
    }
}

