/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.rxmedialoader.loader;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import com.yuyakaido.android.rxmedialoader.entity.Folder;
import com.yuyakaido.android.rxmedialoader.util.FolderUtil;
import java.util.ArrayList;
import java.util.List;

public class FolderLoader
implements LoaderManager.LoaderCallbacks<Cursor> {
    private final Context context;
    private final Callback callback;

    public FolderLoader(Context context, LoaderManager loaderManager, Callback callback) {
        this.context = context;
        this.callback = callback;
        loaderManager.restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        return new InternalFolderLoader(this.context);
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
        int count = cursor.getCount();
        ArrayList<Folder> folders = new ArrayList<Folder>(count);
        if (cursor.moveToFirst()) {
            do {
                folders.add(FolderUtil.valueOf(cursor));
            } while (cursor.moveToNext());
        }
        this.callback.onFolderLoaded(folders);
    }

    private static class InternalFolderLoader
    extends CursorLoader {
        private static final String[] PROJECTION = new String[]{"bucket_id", "bucket_display_name", "_id"};
        private static final String BUCKET_GROUP_BY = "1) GROUP BY (1";
        private static final String BUCKET_ORDER_BY = "MAX(datetaken) DESC";

        public InternalFolderLoader(Context context) {
            super(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, PROJECTION, BUCKET_GROUP_BY, null, BUCKET_ORDER_BY);
        }
    }

    public static interface Callback {
        public void onFolderLoaded(List<Folder> var1);
    }
}

