/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.rxmedialoader;

import android.content.Context;
import android.support.v4.app.LoaderManager;
import com.yuyakaido.android.rxmedialoader.entity.Album;
import com.yuyakaido.android.rxmedialoader.entity.Folder;
import com.yuyakaido.android.rxmedialoader.error.NeedPermissionException;
import com.yuyakaido.android.rxmedialoader.loader.FolderLoader;
import com.yuyakaido.android.rxmedialoader.loader.PhotoLoader;
import com.yuyakaido.android.rxmedialoader.loader.VideoLoader;
import com.yuyakaido.android.rxmedialoader.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public class RxMediaLoader {
    private RxMediaLoader() {
    }

    public static Observable<List<Album>> medias(Context context, LoaderManager loaderManager) {
        return RxMediaLoader.folders(context, loaderManager).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.photosFunc(context, loaderManager)).flatMap(RxMediaLoader.videosFunc(context, loaderManager));
    }

    public static Observable<Album> medias(Context context, LoaderManager loaderManager, Folder folder) {
        return Observable.just(Arrays.asList(folder)).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.photosFunc(context, loaderManager)).flatMap(RxMediaLoader.videosFunc(context, loaderManager)).map((Func1)new Func1<List<Album>, Album>(){

            public Album call(List<Album> albums) {
                return albums.get(0);
            }
        });
    }

    public static Observable<List<Album>> photos(Context context, LoaderManager loaderManager) {
        return RxMediaLoader.folders(context, loaderManager).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.photosFunc(context, loaderManager));
    }

    public static Observable<Album> photos(Context context, LoaderManager loaderManager, Folder folder) {
        return Observable.just(Arrays.asList(folder)).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.photosFunc(context, loaderManager)).map((Func1)new Func1<List<Album>, Album>(){

            public Album call(List<Album> albums) {
                return albums.get(0);
            }
        });
    }

    public static Observable<List<Album>> videos(Context context, LoaderManager loaderManager) {
        return RxMediaLoader.folders(context, loaderManager).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.videosFunc(context, loaderManager));
    }

    public static Observable<Album> videos(Context context, LoaderManager loaderManager, Folder folder) {
        return Observable.just(Arrays.asList(folder)).map(RxMediaLoader.toAlbums()).flatMap(RxMediaLoader.videosFunc(context, loaderManager)).map((Func1)new Func1<List<Album>, Album>(){

            public Album call(List<Album> albums) {
                return albums.get(0);
            }
        });
    }

    private static Observable<List<Folder>> folders(final Context context, final LoaderManager loaderManager) {
        if (!PermissionUtil.hasReadExternalStoragePermission(context)) {
            return Observable.error((Throwable)new NeedPermissionException("This operation needs android.permission.READ_EXTERNAL_STORAGE"));
        }
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<Folder>>(){

            public void call(final Subscriber<? super List<Folder>> subscriber) {
                new FolderLoader(context, loaderManager, new FolderLoader.Callback(){

                    @Override
                    public void onFolderLoaded(List<Folder> folders) {
                        subscriber.onNext(folders);
                        subscriber.onCompleted();
                    }
                });
            }
        });
    }

    private static Func1<List<Folder>, List<Album>> toAlbums() {
        return new Func1<List<Folder>, List<Album>>(){

            public List<Album> call(List<Folder> folders) {
                ArrayList<Album> albums = new ArrayList<Album>();
                for (Folder folder : folders) {
                    albums.add(new Album(folder));
                }
                return albums;
            }
        };
    }

    private static Func1<List<Album>, Observable<List<Album>>> photosFunc(final Context context, final LoaderManager loaderManager) {
        return new Func1<List<Album>, Observable<List<Album>>>(){

            public Observable<List<Album>> call(final List<Album> albums) {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<Album>>(){

                    public void call(final Subscriber<? super List<Album>> subscriber) {
                        new PhotoLoader(context, loaderManager, albums, new PhotoLoader.Callback(){

                            @Override
                            public void onPhotoLoaded(List<Album> albums) {
                                subscriber.onNext(albums);
                                subscriber.onCompleted();
                            }
                        });
                    }
                });
            }
        };
    }

    private static Func1<List<Album>, Observable<List<Album>>> videosFunc(final Context context, final LoaderManager loaderManager) {
        return new Func1<List<Album>, Observable<List<Album>>>(){

            public Observable<List<Album>> call(final List<Album> albums) {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<List<Album>>(){

                    public void call(final Subscriber<? super List<Album>> subscriber) {
                        new VideoLoader(context, loaderManager, albums, new VideoLoader.Callback(){

                            @Override
                            public void onVideoLoaded(List<Album> albums) {
                                subscriber.onNext(albums);
                                subscriber.onCompleted();
                            }
                        });
                    }
                });
            }
        };
    }
}

