/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.Duration;
import com.yuyakaido.android.cardstackview.internal.AnimationSetting;

public class RewindAnimationSetting
implements AnimationSetting {
    private final Direction direction;
    private final int duration;
    private final Interpolator interpolator;

    private RewindAnimationSetting(Direction direction, int duration, Interpolator interpolator) {
        this.direction = direction;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public static class Builder {
        private Direction direction = Direction.Bottom;
        private int duration;
        private Interpolator interpolator;

        public Builder() {
            this.duration = Duration.Normal.duration;
            this.interpolator = new DecelerateInterpolator();
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder setDuration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder setInterpolator(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public RewindAnimationSetting build() {
            return new RewindAnimationSetting(this.direction, this.duration, this.interpolator);
        }
    }
}

