/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview.internal;

import com.yuyakaido.android.cardstackview.Direction;

public class CardStackState {
    public Status status = Status.Idle;
    public int width = 0;
    public int height = 0;
    public int dx = 0;
    public int dy = 0;
    public int topPosition = 0;
    public int targetPosition = -1;
    public float proportion = 0.0f;

    public void next(Status state) {
        this.status = state;
    }

    public Direction getDirection() {
        if (Math.abs(this.dy) < Math.abs(this.dx)) {
            if ((float)this.dx < 0.0f) {
                return Direction.Left;
            }
            return Direction.Right;
        }
        if ((float)this.dy < 0.0f) {
            return Direction.Top;
        }
        return Direction.Bottom;
    }

    public float getRatio() {
        int absDy;
        int absDx = Math.abs(this.dx);
        float ratio = absDx < (absDy = Math.abs(this.dy)) ? (float)absDy / ((float)this.height / 2.0f) : (float)absDx / ((float)this.width / 2.0f);
        return Math.min(ratio, 1.0f);
    }

    public boolean isSwipeCompleted() {
        return this.status.isSwipeAnimating() && this.topPosition < this.targetPosition && (this.width < Math.abs(this.dx) || this.height < Math.abs(this.dy));
    }

    public boolean canScrollToPosition(int position, int itemCount) {
        if (position == this.topPosition) {
            return false;
        }
        if (position < 0) {
            return false;
        }
        if (itemCount < position) {
            return false;
        }
        return !this.status.isBusy();
    }

    public static enum Status {
        Idle,
        Dragging,
        RewindAnimating,
        AutomaticSwipeAnimating,
        AutomaticSwipeAnimated,
        ManualSwipeAnimating,
        ManualSwipeAnimated;


        public boolean isBusy() {
            return this != Idle;
        }

        public boolean isDragging() {
            return this == Dragging;
        }

        public boolean isSwipeAnimating() {
            return this == ManualSwipeAnimating || this == AutomaticSwipeAnimating;
        }

        public Status toAnimatedStatus() {
            switch (this) {
                case ManualSwipeAnimating: {
                    return ManualSwipeAnimated;
                }
                case AutomaticSwipeAnimating: {
                    return AutomaticSwipeAnimated;
                }
            }
            return Idle;
        }
    }
}

