/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.yuyakaido.android.cardstackview.CardStackListener;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.R;
import com.yuyakaido.android.cardstackview.RewindAnimationSetting;
import com.yuyakaido.android.cardstackview.StackFrom;
import com.yuyakaido.android.cardstackview.SwipeAnimationSetting;
import com.yuyakaido.android.cardstackview.internal.CardStackSetting;
import com.yuyakaido.android.cardstackview.internal.CardStackSmoothScroller;
import com.yuyakaido.android.cardstackview.internal.CardStackState;
import com.yuyakaido.android.cardstackview.internal.DisplayUtil;
import java.util.List;

public class CardStackLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private final Context context;
    private CardStackListener listener = CardStackListener.DEFAULT;
    private CardStackSetting setting = new CardStackSetting();
    private CardStackState state = new CardStackState();

    public CardStackLayoutManager(Context context) {
        this(context, CardStackListener.DEFAULT);
    }

    public CardStackLayoutManager(Context context, CardStackListener listener) {
        this.context = context;
        this.listener = listener;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-1, -1);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State s) {
        this.update(recycler);
        if (s.didStructureChange()) {
            this.listener.onCardAppeared(this.getTopView(), this.state.topPosition);
        }
    }

    public boolean canScrollHorizontally() {
        return this.setting.canScrollHorizontal;
    }

    public boolean canScrollVertically() {
        return this.setting.canScrollVertical;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State s) {
        if (this.state.status != CardStackState.Status.SwipeAnimating) {
            this.state.dx -= dx;
            this.update(recycler);
            return dx;
        }
        return 0;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State s) {
        if (this.state.status != CardStackState.Status.SwipeAnimating) {
            this.state.dy -= dy;
            this.update(recycler);
            return dy;
        }
        return 0;
    }

    public void onScrollStateChanged(int s) {
        switch (s) {
            case 0: {
                if (this.state.status != CardStackState.Status.PrepareSwipeAnimation) {
                    if (this.state.targetPosition == -1) {
                        this.state.next(CardStackState.Status.Idle);
                        this.state.targetPosition = -1;
                        break;
                    }
                    if (this.state.topPosition < this.state.targetPosition) {
                        this.smoothScrollToNext(this.state.targetPosition);
                        break;
                    }
                    if (this.state.targetPosition < this.state.topPosition) {
                        this.smoothScrollToPrevious(this.state.targetPosition);
                        break;
                    }
                    this.state.next(CardStackState.Status.Idle);
                    this.state.targetPosition = -1;
                    break;
                }
                this.state.next(CardStackState.Status.Idle);
                this.state.targetPosition = -1;
                break;
            }
            case 1: {
                this.state.next(CardStackState.Status.Dragging);
                break;
            }
            case 2: {
                if (this.state.status == CardStackState.Status.PrepareSwipeAnimation) break;
                if (this.state.targetPosition == -1) {
                    this.state.next(CardStackState.Status.Idle);
                    this.state.targetPosition = -1;
                    break;
                }
                if (this.state.topPosition < this.state.targetPosition) {
                    this.state.next(CardStackState.Status.PrepareSwipeAnimation);
                    break;
                }
                if (this.state.targetPosition >= this.state.topPosition) break;
                this.state.next(CardStackState.Status.RewindAnimating);
            }
        }
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        return null;
    }

    public void scrollToPosition(int position) {
        if (position == this.state.topPosition || position < 0 || this.getItemCount() < position) {
            this.state.next(CardStackState.Status.Idle);
            this.state.targetPosition = -1;
        } else if (this.state.status == CardStackState.Status.Idle) {
            this.state.topPosition = position;
            this.requestLayout();
        }
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State s, int position) {
        if (position == this.state.topPosition || position < 0 || this.getItemCount() < position) {
            this.state.next(CardStackState.Status.Idle);
            this.state.targetPosition = -1;
        } else if (this.state.status == CardStackState.Status.Idle) {
            this.smoothScrollToPosition(position);
        }
    }

    @NonNull
    public CardStackSetting getCardStackSetting() {
        return this.setting;
    }

    @NonNull
    public CardStackState getCardStackState() {
        return this.state;
    }

    @NonNull
    public CardStackListener getCardStackListener() {
        return this.listener;
    }

    void updateProportion(float x, float y) {
        View view;
        if (this.getTopPosition() < this.getItemCount() && (view = this.findViewByPosition(this.getTopPosition())) != null) {
            float half = (float)this.getHeight() / 2.0f;
            this.state.proportion = -(y - half - (float)view.getTop()) / half;
        }
    }

    private void update(RecyclerView.Recycler recycler) {
        this.state.width = this.getWidth();
        this.state.height = this.getHeight();
        if (!(this.state.status != CardStackState.Status.PrepareSwipeAnimation || this.state.targetPosition != -1 && this.state.topPosition >= this.state.targetPosition || Math.abs(this.state.dx) <= this.getWidth() && Math.abs(this.state.dy) <= this.getHeight())) {
            this.state.next(CardStackState.Status.SwipeAnimating);
            ++this.state.topPosition;
            final Direction direction = this.state.getDirection();
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    CardStackLayoutManager.this.listener.onCardSwiped(direction);
                    CardStackLayoutManager.this.listener.onCardAppeared(CardStackLayoutManager.this.getTopView(), ((CardStackLayoutManager)CardStackLayoutManager.this).state.topPosition);
                }
            });
            this.state.dx = 0;
            this.state.dy = 0;
        }
        this.removeAndRecycleAllViews(recycler);
        int parentTop = this.getPaddingTop();
        int parentLeft = this.getPaddingLeft();
        int parentRight = this.getWidth() - this.getPaddingLeft();
        int parentBottom = this.getHeight() - this.getPaddingBottom();
        for (int i = this.state.topPosition; i < this.state.topPosition + this.setting.visibleCount && i < this.getItemCount(); ++i) {
            View child = recycler.getViewForPosition(i);
            this.addView(child, 0);
            this.measureChildWithMargins(child, 0, 0);
            this.layoutDecoratedWithMargins(child, parentLeft, parentTop, parentRight, parentBottom);
            this.resetTranslation(child);
            this.resetScale(child);
            this.resetRotation(child);
            this.resetOverlay(child);
            if (i == this.state.topPosition) {
                this.updateTranslation(child);
                this.resetScale(child);
                this.updateRotation(child);
                this.updateOverlay(child);
                continue;
            }
            int currentIndex = i - this.state.topPosition;
            this.updateTranslation(child, currentIndex);
            this.updateScale(child, currentIndex);
            this.resetRotation(child);
            this.resetOverlay(child);
        }
        if (this.state.status == CardStackState.Status.Dragging) {
            this.listener.onCardDragging(this.state.getDirection(), this.state.getRatio());
        }
    }

    private void updateTranslation(View view) {
        view.setTranslationX((float)this.state.dx);
        view.setTranslationY((float)this.state.dy);
    }

    private void updateTranslation(View view, int index) {
        int nextIndex = index - 1;
        int translationPx = DisplayUtil.dpToPx(this.context, this.setting.translationInterval);
        float currentTranslation = index * translationPx;
        float nextTranslation = nextIndex * translationPx;
        float targetTranslation = currentTranslation - (currentTranslation - nextTranslation) * this.state.getRatio();
        switch (this.setting.stackFrom) {
            case None: {
                break;
            }
            case Top: {
                view.setTranslationY(-targetTranslation);
                break;
            }
            case Bottom: {
                view.setTranslationY(targetTranslation);
                break;
            }
            case Left: {
                view.setTranslationX(-targetTranslation);
                break;
            }
            case Right: {
                view.setTranslationX(targetTranslation);
            }
        }
    }

    private void resetTranslation(View view) {
        view.setTranslationX(0.0f);
        view.setTranslationY(0.0f);
    }

    private void updateScale(View view, int index) {
        int nextIndex = index - 1;
        float currentScale = 1.0f - (float)index * (1.0f - this.setting.scaleInterval);
        float nextScale = 1.0f - (float)nextIndex * (1.0f - this.setting.scaleInterval);
        float targetScale = currentScale + (nextScale - currentScale) * this.state.getRatio();
        switch (this.setting.stackFrom) {
            case None: {
                view.setScaleX(targetScale);
                view.setScaleY(targetScale);
                break;
            }
            case Top: {
                view.setScaleX(targetScale);
                break;
            }
            case Bottom: {
                view.setScaleX(targetScale);
                break;
            }
            case Left: {
                view.setScaleY(targetScale);
                break;
            }
            case Right: {
                view.setScaleY(targetScale);
            }
        }
    }

    private void resetScale(View view) {
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
    }

    private void updateRotation(View view) {
        float degree = (float)this.state.dx * this.setting.maxDegree / (float)this.getWidth() * this.state.proportion;
        view.setRotation(degree);
    }

    private void resetRotation(View view) {
        view.setRotation(0.0f);
    }

    private void updateOverlay(View view) {
        View bottomOverlay;
        View topOverlay;
        View rightOverlay;
        View leftOverlay = view.findViewById(R.id.left_overlay);
        if (leftOverlay != null) {
            leftOverlay.setAlpha(0.0f);
        }
        if ((rightOverlay = view.findViewById(R.id.right_overlay)) != null) {
            rightOverlay.setAlpha(0.0f);
        }
        if ((topOverlay = view.findViewById(R.id.top_overlay)) != null) {
            topOverlay.setAlpha(0.0f);
        }
        if ((bottomOverlay = view.findViewById(R.id.bottom_overlay)) != null) {
            bottomOverlay.setAlpha(0.0f);
        }
        Direction direction = this.state.getDirection();
        switch (direction) {
            case Left: {
                if (leftOverlay == null) break;
                leftOverlay.setAlpha(this.state.getRatio());
                break;
            }
            case Right: {
                if (rightOverlay == null) break;
                rightOverlay.setAlpha(this.state.getRatio());
                break;
            }
            case Top: {
                if (topOverlay == null) break;
                topOverlay.setAlpha(this.state.getRatio());
                break;
            }
            case Bottom: {
                if (bottomOverlay == null) break;
                bottomOverlay.setAlpha(this.state.getRatio());
            }
        }
    }

    private void resetOverlay(View view) {
        View bottomOverlay;
        View topOverlay;
        View rightOverlay;
        View leftOverlay = view.findViewById(R.id.left_overlay);
        if (leftOverlay != null) {
            leftOverlay.setAlpha(0.0f);
        }
        if ((rightOverlay = view.findViewById(R.id.right_overlay)) != null) {
            rightOverlay.setAlpha(0.0f);
        }
        if ((topOverlay = view.findViewById(R.id.top_overlay)) != null) {
            topOverlay.setAlpha(0.0f);
        }
        if ((bottomOverlay = view.findViewById(R.id.bottom_overlay)) != null) {
            bottomOverlay.setAlpha(0.0f);
        }
    }

    private void smoothScrollToPosition(int position) {
        if (this.state.topPosition < position) {
            this.smoothScrollToNext(position);
        } else {
            this.smoothScrollToPrevious(position);
        }
    }

    private void smoothScrollToNext(int position) {
        this.state.proportion = 0.0f;
        this.state.targetPosition = position;
        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.AutomaticSwipe, this);
        scroller.setTargetPosition(this.state.topPosition);
        this.startSmoothScroll(scroller);
    }

    private void smoothScrollToPrevious(int position) {
        this.listener.onCardDisappeared(this.getTopView(), this.state.topPosition);
        this.state.proportion = 0.0f;
        this.state.targetPosition = position;
        --this.state.topPosition;
        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.AutomaticRewind, this);
        scroller.setTargetPosition(this.state.topPosition);
        this.startSmoothScroll(scroller);
    }

    public View getTopView() {
        return this.findViewByPosition(this.state.topPosition);
    }

    public int getTopPosition() {
        return this.state.topPosition;
    }

    public void setTopPosition(int topPosition) {
        this.state.topPosition = topPosition;
    }

    public void setStackFrom(@NonNull StackFrom stackFrom) {
        this.setting.stackFrom = stackFrom;
    }

    public void setVisibleCount(@IntRange(from=1L) int visibleCount) {
        if (visibleCount < 1) {
            throw new IllegalArgumentException("VisibleCount must be greater than 0.");
        }
        this.setting.visibleCount = visibleCount;
    }

    public void setTranslationInterval(@FloatRange(from=0.0) float translationInterval) {
        if (translationInterval < 0.0f) {
            throw new IllegalArgumentException("TranslationInterval must be greater than or equal 0.0f");
        }
        this.setting.translationInterval = translationInterval;
    }

    public void setScaleInterval(@FloatRange(from=0.0) float scaleInterval) {
        if (scaleInterval < 0.0f) {
            throw new IllegalArgumentException("ScaleInterval must be greater than or equal 0.0f.");
        }
        this.setting.scaleInterval = scaleInterval;
    }

    public void setSwipeThreshold(@FloatRange(from=0.0, to=1.0) float swipeThreshold) {
        if (swipeThreshold < 0.0f || 1.0f < swipeThreshold) {
            throw new IllegalArgumentException("SwipeThreshold must be 0.0f to 1.0f.");
        }
        this.setting.swipeThreshold = swipeThreshold;
    }

    public void setMaxDegree(@FloatRange(from=-360.0, to=360.0) float maxDegree) {
        if (maxDegree < -360.0f || 360.0f < maxDegree) {
            throw new IllegalArgumentException("MaxDegree must be -360.0f to 360.0f");
        }
        this.setting.maxDegree = maxDegree;
    }

    public void setDirections(@NonNull List<Direction> directions) {
        this.setting.directions = directions;
    }

    public void setCanScrollHorizontal(boolean canScrollHorizontal) {
        this.setting.canScrollHorizontal = canScrollHorizontal;
    }

    public void setCanScrollVertical(boolean canScrollVertical) {
        this.setting.canScrollVertical = canScrollVertical;
    }

    public void setSwipeAnimationSetting(@NonNull SwipeAnimationSetting swipeAnimationSetting) {
        this.setting.swipeAnimationSetting = swipeAnimationSetting;
    }

    public void setRewindAnimationSetting(@NonNull RewindAnimationSetting rewindAnimationSetting) {
        this.setting.rewindAnimationSetting = rewindAnimationSetting;
    }
}

