/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.internal.CardStackSnapHelper;

public class CardStackView
extends RecyclerView {
    private final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        private CardStackLayoutManager getCardStackLayoutManager() {
            RecyclerView.LayoutManager manager = CardStackView.this.getLayoutManager();
            if (manager instanceof CardStackLayoutManager) {
                return (CardStackLayoutManager)manager;
            }
            throw new IllegalStateException("CardStackView must be set CardStackLayoutManager.");
        }

        public void onChanged() {
            CardStackLayoutManager manager = this.getCardStackLayoutManager();
            manager.setTopPosition(0);
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            CardStackLayoutManager manager = this.getCardStackLayoutManager();
            if (positionStart == 0) {
                manager.setTopPosition(0);
            }
            manager.removeAllViews();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        }
    };

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize();
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        if (!(manager instanceof CardStackLayoutManager)) {
            throw new IllegalArgumentException("CardStackView must be set CardStackLayoutManager.");
        }
        super.setLayoutManager(manager);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(new CardStackLayoutManager(this.getContext()));
        }
        super.setAdapter(adapter);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.registerAdapterDataObserver(this.observer);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.unregisterAdapterDataObserver(this.observer);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            manager.updateProportion(event.getX(), event.getY());
        }
        return super.onInterceptTouchEvent(event);
    }

    public void swipe() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() + 1);
        }
    }

    public void rewind() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() - 1);
        }
    }

    private void initialize() {
        new CardStackSnapHelper().attachToRecyclerView(this);
    }
}

