/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yuyakaido.android.cardstackview.CardStackLayoutManager;
import com.yuyakaido.android.cardstackview.internal.CardStackSnapHelper;

public class CardStackView
extends RecyclerView
implements View.OnTouchListener {
    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize();
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        if (!(manager instanceof CardStackLayoutManager)) {
            throw new IllegalArgumentException("CardStackView must be set CardStackLayoutManager.");
        }
        super.setLayoutManager(manager);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(new CardStackLayoutManager(this.getContext()));
        }
        super.setAdapter(adapter);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            manager.updateProportion(event.getX(), event.getY());
        }
        return false;
    }

    public void swipe() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() + 1);
        }
    }

    public void rewind() {
        if (this.getLayoutManager() instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)this.getLayoutManager();
            this.smoothScrollToPosition(manager.getTopPosition() - 1);
        }
    }

    private void initialize() {
        new CardStackSnapHelper().attachToRecyclerView(this);
        this.setOnTouchListener(this);
    }
}

