/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Point;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import com.yuyakaido.android.cardstackview.Quadrant;
import com.yuyakaido.android.cardstackview.R;
import com.yuyakaido.android.cardstackview.StackFrom;
import com.yuyakaido.android.cardstackview.SwipeDirection;
import com.yuyakaido.android.cardstackview.internal.CardContainerView;
import com.yuyakaido.android.cardstackview.internal.CardStackOption;
import com.yuyakaido.android.cardstackview.internal.CardStackState;
import com.yuyakaido.android.cardstackview.internal.Util;
import java.util.LinkedList;
import java.util.List;

public class CardStackView
extends FrameLayout {
    private CardStackOption option = new CardStackOption();
    private CardStackState state = new CardStackState();
    private ArrayAdapter<?> adapter = null;
    private LinkedList<CardContainerView> containers = new LinkedList();
    private CardEventListener cardEventListener = null;
    private DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            boolean shouldReset = false;
            if (((CardStackView)CardStackView.this).state.isPaginationReserved) {
                ((CardStackView)CardStackView.this).state.isPaginationReserved = false;
            } else {
                boolean isSameCount = ((CardStackView)CardStackView.this).state.lastCount.intValue() == CardStackView.this.adapter.getCount();
                shouldReset = !isSameCount;
            }
            CardStackView.this.initialize(shouldReset);
            ((CardStackView)CardStackView.this).state.lastCount = CardStackView.this.adapter.getCount();
        }
    };
    private CardContainerView.ContainerEventListener containerEventListener = new CardContainerView.ContainerEventListener(){

        @Override
        public void onContainerDragging(float percentX, float percentY) {
            CardStackView.this.update(percentX, percentY);
        }

        @Override
        public void onContainerSwiped(Point point) {
            CardStackView.this.swipe(point);
        }

        @Override
        public void onContainerMovedToOrigin() {
            CardStackView.this.initializeCardStackPosition();
            if (CardStackView.this.cardEventListener != null) {
                CardStackView.this.cardEventListener.onCardMovedToOrigin();
            }
        }

        @Override
        public void onContainerClicked() {
            if (CardStackView.this.cardEventListener != null) {
                CardStackView.this.cardEventListener.onCardClicked(((CardStackView)CardStackView.this).state.topIndex);
            }
        }
    };

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CardStackView);
        this.setVisibleCount(array.getInt(R.styleable.CardStackView_visibleCount, this.option.visibleCount));
        this.setSwipeThreshold(array.getFloat(R.styleable.CardStackView_swipeThreshold, this.option.swipeThreshold));
        this.setTranslationDiff(array.getFloat(R.styleable.CardStackView_translationDiff, this.option.translationDiff));
        this.setScaleDiff(array.getFloat(R.styleable.CardStackView_scaleDiff, this.option.scaleDiff));
        this.setStackFrom(StackFrom.values()[array.getInt(R.styleable.CardStackView_stackFrom, this.option.stackFrom.ordinal())]);
        this.setElevationEnabled(array.getBoolean(R.styleable.CardStackView_elevationEnabled, this.option.isElevationEnabled));
        this.setSwipeEnabled(array.getBoolean(R.styleable.CardStackView_swipeEnabled, this.option.isSwipeEnabled));
        this.setSwipeDirection(SwipeDirection.from(array.getInt(R.styleable.CardStackView_swipeDirection, 0)));
        this.setLeftOverlay(array.getResourceId(R.styleable.CardStackView_leftOverlay, 0));
        this.setRightOverlay(array.getResourceId(R.styleable.CardStackView_rightOverlay, 0));
        array.recycle();
    }

    private void initialize(boolean shouldReset) {
        this.resetIfNeeded(shouldReset);
        this.initializeViews();
        this.initializeCardStackPosition();
        this.initializeViewContents();
    }

    private void resetIfNeeded(boolean shouldReset) {
        if (shouldReset) {
            this.state.topIndex = 0;
            this.state.lastPoint = null;
        }
    }

    private void initializeViews() {
        this.removeAllViews();
        this.containers.clear();
        for (int i = 0; i < this.option.visibleCount; ++i) {
            CardContainerView view = (CardContainerView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.card_container, (ViewGroup)this, false);
            view.setDraggable(false);
            view.setCardStackOption(this.option);
            view.setOverlay(this.option.leftOverlay, this.option.rightOverlay);
            this.containers.add(0, view);
            this.addView((View)view);
        }
        this.containers.getFirst().setContainerEventListener(this.containerEventListener);
    }

    private void initializeCardStackPosition() {
        this.clear();
        this.update(0.0f, 0.0f);
    }

    private void initializeViewContents() {
        for (int i = 0; i < this.option.visibleCount; ++i) {
            CardContainerView container = this.containers.get(i);
            int adapterIndex = this.state.topIndex + i;
            if (adapterIndex < this.adapter.getCount()) {
                ViewGroup parent = container.getContentContainer();
                View child = this.adapter.getView(adapterIndex, parent.getChildAt(0), parent);
                if (parent.getChildCount() == 0) {
                    parent.addView(child);
                }
                container.setVisibility(0);
                continue;
            }
            container.setVisibility(8);
        }
        if (!this.adapter.isEmpty()) {
            this.getTopView().setDraggable(true);
        }
    }

    private void loadNextView() {
        boolean hasCard;
        CardContainerView container;
        boolean hasNextCard;
        int lastIndex = this.state.topIndex + this.option.visibleCount - 1;
        boolean bl = hasNextCard = lastIndex < this.adapter.getCount();
        if (hasNextCard) {
            container = this.getBottomView();
            container.setDraggable(false);
            ViewGroup parent = container.getContentContainer();
            View child = this.adapter.getView(lastIndex, parent.getChildAt(0), parent);
            if (parent.getChildCount() == 0) {
                parent.addView(child);
            }
        } else {
            container = this.getBottomView();
            container.setDraggable(false);
            container.setVisibility(8);
        }
        boolean bl2 = hasCard = this.state.topIndex < this.adapter.getCount();
        if (hasCard) {
            this.getTopView().setDraggable(true);
        }
    }

    private void clear() {
        for (int i = 0; i < this.option.visibleCount; ++i) {
            CardContainerView view = this.containers.get(i);
            view.reset();
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setScaleX((View)view, (float)1.0f);
            ViewCompat.setScaleY((View)view, (float)1.0f);
            ViewCompat.setRotation((View)view, (float)0.0f);
        }
    }

    private void update(float percentX, float percentY) {
        if (this.cardEventListener != null) {
            this.cardEventListener.onCardDragging(percentX, percentY);
        }
        if (!this.option.isElevationEnabled) {
            return;
        }
        for (int i = 1; i < this.option.visibleCount; ++i) {
            CardContainerView view = this.containers.get(i);
            float currentScale = 1.0f - (float)i * this.option.scaleDiff;
            float nextScale = 1.0f - (float)(i - 1) * this.option.scaleDiff;
            float percent = currentScale + (nextScale - currentScale) * Math.abs(percentX);
            ViewCompat.setScaleX((View)view, (float)percent);
            ViewCompat.setScaleY((View)view, (float)percent);
            float currentTranslationY = (float)i * Util.toPx(this.getContext(), this.option.translationDiff);
            if (this.option.stackFrom == StackFrom.Top) {
                currentTranslationY *= -1.0f;
            }
            float nextTranslationY = (float)(i - 1) * Util.toPx(this.getContext(), this.option.translationDiff);
            if (this.option.stackFrom == StackFrom.Top) {
                nextTranslationY *= -1.0f;
            }
            float translationY = currentTranslationY - Math.abs(percentX) * (currentTranslationY - nextTranslationY);
            ViewCompat.setTranslationY((View)view, (float)translationY);
        }
    }

    public void performReverse(Point point, View prevView, Animator.AnimatorListener listener) {
        this.reorderForReverse(prevView);
        CardContainerView topView = this.getTopView();
        ViewCompat.setTranslationX((View)topView, (float)point.x);
        ViewCompat.setTranslationY((View)topView, (float)(-point.y));
        topView.animate().translationX(topView.getViewOriginX()).translationY(topView.getViewOriginY()).setListener(listener).setDuration(400L).start();
    }

    public void performSwipe(Point point, Animator.AnimatorListener listener) {
        this.getTopView().animate().translationX((float)point.x).translationY((float)(-point.y)).setDuration(400L).setListener(listener).start();
    }

    public void performSwipe(SwipeDirection direction, AnimatorSet set, Animator.AnimatorListener listener) {
        if (direction == SwipeDirection.Left) {
            this.getTopView().showLeftOverlay();
            this.getTopView().setOverlayAlpha(1.0f);
        } else if (direction == SwipeDirection.Right) {
            this.getTopView().showRightOverlay();
            this.getTopView().setOverlayAlpha(1.0f);
        }
        set.addListener(listener);
        set.start();
    }

    private void moveToBottom(CardContainerView container) {
        CardStackView parent = (CardStackView)container.getParent();
        if (parent != null) {
            parent.removeView((View)container);
            parent.addView((View)container, 0);
        }
    }

    private void moveToTop(CardContainerView container, View child) {
        CardStackView parent = (CardStackView)container.getParent();
        if (parent != null) {
            parent.removeView((View)container);
            parent.addView((View)container);
            container.getContentContainer().removeAllViews();
            container.getContentContainer().addView(child);
            container.setVisibility(0);
        }
    }

    private void reorderForSwipe() {
        this.moveToBottom(this.getTopView());
        this.containers.addLast(this.containers.removeFirst());
    }

    private void reorderForReverse(View prevView) {
        CardContainerView bottomView = this.getBottomView();
        this.moveToTop(bottomView, prevView);
        this.containers.addFirst(this.containers.removeLast());
    }

    private void executePreSwipeTask() {
        this.containers.getFirst().setContainerEventListener(null);
        this.containers.getFirst().setDraggable(false);
        this.containers.get(1).setContainerEventListener(this.containerEventListener);
        this.containers.get(1).setDraggable(true);
    }

    private void executePostSwipeTask(Point point) {
        this.reorderForSwipe();
        this.state.lastPoint = point;
        this.initializeCardStackPosition();
        ++this.state.topIndex;
        if (this.cardEventListener != null) {
            this.cardEventListener.onCardSwiped(Util.getQuadrant(this.getTopView().getViewOriginX(), this.getTopView().getViewOriginY(), point.x, -point.y));
        }
        this.loadNextView();
        this.containers.getLast().setContainerEventListener(null);
        this.containers.getFirst().setContainerEventListener(this.containerEventListener);
    }

    private void executePostReverseTask() {
        this.state.lastPoint = null;
        this.initializeCardStackPosition();
        --this.state.topIndex;
        if (this.cardEventListener != null) {
            this.cardEventListener.onCardReversed();
        }
        this.containers.getLast().setContainerEventListener(null);
        this.containers.getFirst().setContainerEventListener(this.containerEventListener);
        this.getTopView().setDraggable(true);
    }

    public void setCardEventListener(CardEventListener listener) {
        this.cardEventListener = listener;
    }

    public void setAdapter(ArrayAdapter<?> adapter) {
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.dataSetObserver);
        }
        this.adapter = adapter;
        this.adapter.registerDataSetObserver(this.dataSetObserver);
        this.state.lastCount = adapter.getCount();
        this.initialize(true);
    }

    public void setVisibleCount(int visibleCount) {
        this.option.visibleCount = visibleCount;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setSwipeThreshold(float swipeThreshold) {
        this.option.swipeThreshold = swipeThreshold;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setTranslationDiff(float translationDiff) {
        this.option.translationDiff = translationDiff;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setScaleDiff(float scaleDiff) {
        this.option.scaleDiff = scaleDiff;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setStackFrom(StackFrom stackFrom) {
        this.option.stackFrom = stackFrom;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setElevationEnabled(boolean isElevationEnabled) {
        this.option.isElevationEnabled = isElevationEnabled;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.option.isSwipeEnabled = isSwipeEnabled;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setSwipeDirection(List<SwipeDirection> swipeDirection) {
        this.option.swipeDirection = swipeDirection;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setLeftOverlay(int leftOverlay) {
        this.option.leftOverlay = leftOverlay;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setRightOverlay(int rightOverlay) {
        this.option.rightOverlay = rightOverlay;
        if (this.adapter != null) {
            this.initialize(false);
        }
    }

    public void setPaginationReserved() {
        this.state.isPaginationReserved = true;
    }

    public void swipe(final Point point) {
        this.executePreSwipeTask();
        this.performSwipe(point, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                CardStackView.this.executePostSwipeTask(point);
            }
        });
    }

    public void swipe(SwipeDirection direction, AnimatorSet set) {
        this.executePreSwipeTask();
        this.performSwipe(direction, set, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                CardStackView.this.executePostSwipeTask(new Point(0, -2000));
            }
        });
    }

    public void reverse() {
        if (this.state.lastPoint != null) {
            ViewGroup parent = (ViewGroup)this.containers.getLast();
            View prevView = this.adapter.getView(this.state.topIndex - 1, null, parent);
            this.performReverse(this.state.lastPoint, prevView, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    CardStackView.this.executePostReverseTask();
                }
            });
        }
    }

    public CardContainerView getTopView() {
        return this.containers.getFirst();
    }

    public CardContainerView getBottomView() {
        return this.containers.getLast();
    }

    public int getTopIndex() {
        return this.state.topIndex;
    }

    public static interface CardEventListener {
        public void onCardDragging(float var1, float var2);

        public void onCardSwiped(Quadrant var1);

        public void onCardReversed();

        public void onCardMovedToOrigin();

        public void onCardClicked(int var1);
    }
}

