/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;

public class DragGestureDetector {
    private GestureDetectorCompat gestureDetector;
    private DragListener dragListener;
    private MotionEvent prevMotionEvent;
    private boolean isDragging;

    public DragGestureDetector(Context context, DragListener dragListener) {
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new InternalGestureListener());
        this.dragListener = dragListener;
    }

    public void onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 1: {
                if (this.isDragging) {
                    this.dragListener.onEndDrag(this.prevMotionEvent, event);
                }
                this.isDragging = false;
                break;
            }
            case 0: {
                this.prevMotionEvent = event;
            }
        }
    }

    private class InternalGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private InternalGestureListener() {
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (DragGestureDetector.this.isDragging) {
                DragGestureDetector.this.dragListener.onDragging(e1, e2);
            } else {
                DragGestureDetector.this.dragListener.onBeginDrag(e1, e2);
                DragGestureDetector.this.isDragging = true;
            }
            DragGestureDetector.this.prevMotionEvent = e1;
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            DragGestureDetector.this.dragListener.onTapUp();
            return true;
        }
    }

    public static interface DragListener {
        public void onBeginDrag(MotionEvent var1, MotionEvent var2);

        public void onDragging(MotionEvent var1, MotionEvent var2);

        public void onEndDrag(MotionEvent var1, MotionEvent var2);

        public void onTapUp();
    }
}

