/*
 * Decompiled with CFR 0.152.
 */
package com.yuyakaido.android.cardstackview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.yuyakaido.android.cardstackview.CardAnimator;
import com.yuyakaido.android.cardstackview.CardUtil;
import com.yuyakaido.android.cardstackview.Direction;
import com.yuyakaido.android.cardstackview.DragGestureDetector;
import java.util.ArrayList;
import java.util.List;

public class CardStackView
extends RelativeLayout {
    private int topIndex = 0;
    private int visibleCount = 4;
    private ArrayAdapter<?> adapter;
    private View.OnTouchListener onTouchListener;
    private CardAnimator cardAnimator;
    private List<ViewGroup> containers = new ArrayList<ViewGroup>();
    private CardStackEventListener cardStackEventListener;
    private Direction lastDirection;
    private DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            CardStackView.this.init(false);
        }
    };

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void init(boolean resetIndex) {
        if (resetIndex) {
            this.topIndex = 0;
        }
        this.removeAllViews();
        this.containers.clear();
        for (int i = 0; i < this.visibleCount; ++i) {
            this.addContainerViews();
        }
        this.setupAnimation();
        this.loadViews();
    }

    public void setAdapter(ArrayAdapter<?> adapter) {
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.dataSetObserver);
        }
        this.adapter = adapter;
        this.adapter.registerDataSetObserver(this.dataSetObserver);
        this.init(true);
    }

    public void setCardStackEventListener(CardStackEventListener listener) {
        this.cardStackEventListener = listener;
    }

    public void addContainerViews() {
        FrameLayout v = new FrameLayout(this.getContext());
        this.containers.add((ViewGroup)v);
        this.addView((View)v);
    }

    public void setupAnimation() {
        this.cardAnimator = new CardAnimator(this.getContext(), this.containers);
        this.cardAnimator.initCards();
        final DragGestureDetector dragGestureDetector = new DragGestureDetector(this.getContext(), new DragGestureDetector.DragListener(){

            @Override
            public void onBeginDrag(MotionEvent e1, MotionEvent e2) {
                CardStackView.this.cardAnimator.drag(e1, e2);
            }

            @Override
            public void onDragging(MotionEvent e1, MotionEvent e2) {
                CardStackView.this.cardAnimator.drag(e1, e2);
                if (CardStackView.this.cardStackEventListener != null) {
                    float x1 = e1.getRawX();
                    float y1 = e1.getRawY();
                    float x2 = e2.getRawX();
                    float y2 = e2.getRawY();
                    CardStackView.this.cardStackEventListener.onSwiping(CardUtil.getDirection(x1, y1, x2, y2));
                }
            }

            @Override
            public void onEndDrag(MotionEvent e1, MotionEvent e2) {
                float x1 = e1.getRawX();
                float y1 = e1.getRawY();
                float x2 = e2.getRawX();
                float y2 = e2.getRawY();
                float distance = CardUtil.getDistance(x1, y1, x2, y2);
                Direction direction = CardUtil.getDirection(x1, y1, x2, y2);
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onEndSwipe(direction);
                }
                if (distance < 300.0f) {
                    CardStackView.this.cardAnimator.moveToOrigin();
                } else {
                    CardStackView.this.discard(direction);
                }
            }

            @Override
            public void onTapUp() {
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onTapUp(CardStackView.this.topIndex);
                }
            }
        });
        this.onTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                dragGestureDetector.onTouchEvent(event);
                return true;
            }
        };
        this.containers.get(this.containers.size() - 1).setOnTouchListener(this.onTouchListener);
    }

    public void loadViews() {
        for (int i = this.visibleCount - 1; i >= 0; --i) {
            ViewGroup parent = this.containers.get(i);
            int adapterIndex = this.topIndex + this.visibleCount - 1 - i;
            if (adapterIndex > this.adapter.getCount() - 1) {
                parent.setVisibility(8);
                continue;
            }
            View child = this.adapter.getView(adapterIndex, parent.getChildAt(0), (ViewGroup)this);
            parent.addView(child);
            parent.setVisibility(0);
        }
    }

    public void loadNextView() {
        ViewGroup parent = this.containers.get(0);
        int lastIndex = this.visibleCount - 1 + this.topIndex;
        if (lastIndex > this.adapter.getCount() - 1) {
            parent.setVisibility(8);
            return;
        }
        View child = this.adapter.getView(lastIndex, parent.getChildAt(0), parent);
        parent.removeAllViews();
        parent.addView(child);
    }

    public void discard(final Direction direction) {
        this.cardAnimator.discard(direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator arg0) {
                CardStackView.this.lastDirection = direction;
                CardStackView.this.cardAnimator.initCards();
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onDiscarded(CardStackView.this.topIndex, direction);
                }
                CardStackView.this.topIndex++;
                CardStackView.this.loadNextView();
                ((ViewGroup)CardStackView.this.containers.get(0)).setOnTouchListener(null);
                ((ViewGroup)CardStackView.this.containers.get(CardStackView.this.containers.size() - 1)).setOnTouchListener(CardStackView.this.onTouchListener);
            }
        });
    }

    public void discard(ObjectAnimator topAnimator) {
        this.cardAnimator.discard(Direction.BottomRight, topAnimator, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator arg0) {
                CardStackView.this.lastDirection = Direction.BottomRight;
                CardStackView.this.cardAnimator.initCards();
                if (CardStackView.this.cardStackEventListener != null) {
                    CardStackView.this.cardStackEventListener.onDiscarded(CardStackView.this.topIndex, Direction.BottomRight);
                }
                CardStackView.this.topIndex++;
                CardStackView.this.loadNextView();
                ((ViewGroup)CardStackView.this.containers.get(0)).setOnTouchListener(null);
                ((ViewGroup)CardStackView.this.containers.get(CardStackView.this.containers.size() - 1)).setOnTouchListener(CardStackView.this.onTouchListener);
            }
        });
    }

    public void reverse() {
        if (this.lastDirection != null) {
            --this.topIndex;
            ViewGroup parent = this.containers.get(0);
            View prevView = this.adapter.getView(this.topIndex, null, parent);
            this.cardAnimator.reverse(this.lastDirection, prevView, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    CardStackView.this.lastDirection = null;
                    ((ViewGroup)CardStackView.this.containers.get(0)).setOnTouchListener(null);
                    ((ViewGroup)CardStackView.this.containers.get(CardStackView.this.containers.size() - 1)).setOnTouchListener(CardStackView.this.onTouchListener);
                }
            });
        }
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public ViewGroup getTopView() {
        return this.cardAnimator.getTopView();
    }

    public static interface CardStackEventListener {
        public void onBeginSwipe(Direction var1);

        public void onEndSwipe(Direction var1);

        public void onSwiping(Direction var1);

        public void onDiscarded(int var1, Direction var2);

        public void onTapUp(int var1);
    }
}

