/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.User;
import com.yunpian.sdk.util.ApiUtil;
import com.yunpian.sdk.util.JsonUtil;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class UserApi
extends YunpianApi {
    public static final String NAME = "user";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.user.host", "https://sms.yunpian.com"));
    }

    public Result<User> get() {
        Result<User> r = new Result<User>();
        List<NameValuePair> list = this.param2pair(null, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<User> h = new YunpianApiResult.MapResultHandler<User>(){

            @Override
            public User data(Map<String, String> rsp) {
                switch (UserApi.this.version()) {
                    case "v1": {
                        return JsonUtil.fromJson(rsp.get(UserApi.NAME), User.class);
                    }
                    case "v2": {
                        return UserApi.map2User(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, UserApi.this.version());
            }
        };
        try {
            return this.path("get.json").post(data, h);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, null);
        }
    }

    public Result<User> set(Map<String, String> param) {
        Result<User> r = new Result<User>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<User> h = new YunpianApiResult.MapResultHandler<User>(){

            @Override
            public User data(Map<String, String> rsp) {
                switch (UserApi.this.version()) {
                    case "v2": {
                        return UserApi.map2User(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, UserApi.this.version());
            }
        };
        try {
            return this.path("set.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public static final User map2User(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            User user = new User();
            user.setNick(map.get("nick"));
            user.setAlarm_balance(Long.parseLong(map.get("alarm_balance")));
            user.setBalance(Double.parseDouble(map.get("balance")));
            user.setEmail(map.get("email"));
            user.setEmergency_contact(map.get("emergency_contact"));
            user.setEmergency_mobile(map.get("emergency_mobile"));
            user.setGmt_created(ApiUtil.str2date(map.get("gmt_created")));
            user.setIp_whitelist(map.get("ip_whitelist"));
            user.setMobile(map.get("mobile"));
            return user;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
            return null;
        }
    }
}

