/*
 * Decompiled with CFR 0.152.
 */
package com.qipeng.captcha;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import com.qipeng.captcha.QPCaptchaListener;
import com.qipeng.captcha.utils.QPUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.json.JSONObject;

public class QPCaptchaConfig {
    public static final String LANG_ZH = "zh-cn";
    public static final String LANG_EN = "en";
    private Activity context;
    private float alpha;
    private boolean isShowLoadingView;
    private QPCaptchaListener callback;
    private JSONObject langPackModel;
    private int width;
    private int expired;
    private String lang;
    private String username;

    private QPCaptchaConfig(Context context) {
        this.width = QPUtils.getScreenWidth(context) - QPUtils.dip2px(context, 32.0f);
        this.alpha = 0.7f;
        this.isShowLoadingView = true;
        this.expired = 30;
        this.lang = LANG_ZH;
    }

    public Activity getContext() {
        return this.context;
    }

    private void setContext(Activity activity) {
        this.context = activity;
    }

    public float getAlpha() {
        return this.alpha;
    }

    private void setAlpha(float f) {
        this.alpha = f;
    }

    public boolean isShowLoadingView() {
        return this.isShowLoadingView;
    }

    public void setShowLoadingView(boolean bl) {
        this.isShowLoadingView = bl;
    }

    private void showLoadingView(boolean bl) {
        this.isShowLoadingView = bl;
    }

    public QPCaptchaListener getCallback() {
        return this.callback;
    }

    private void setCallback(QPCaptchaListener qPCaptchaListener) {
        this.callback = qPCaptchaListener;
    }

    private void setLangPackModel(JSONObject jSONObject) {
        this.langPackModel = jSONObject;
    }

    public JSONObject getLangPackModel() {
        return this.langPackModel;
    }

    private void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    private void setLang(String string) {
        this.lang = string;
    }

    public String getLang() {
        return this.lang;
    }

    private void setExpired(int n) {
        this.expired = n;
    }

    public int getExpired() {
        return this.expired;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public static final class Builder {
        private QPCaptchaConfig config;

        public Builder(Activity activity) {
            this.config = new QPCaptchaConfig((Context)activity);
            this.config.setContext(activity);
        }

        public final QPCaptchaConfig build() {
            return this.config;
        }

        public final Builder setCallback(QPCaptchaListener qPCaptchaListener) {
            this.config.setCallback(qPCaptchaListener);
            return this;
        }

        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float f) {
            this.config.setAlpha(f);
            return this;
        }

        public final Builder showLoadingView(boolean bl) {
            this.config.showLoadingView(bl);
            return this;
        }

        public final Builder setLangPackModel(JSONObject jSONObject) {
            this.config.setLangPackModel(jSONObject);
            return this;
        }

        public final Builder setWidth(int n) {
            this.config.setWidth(n);
            return this;
        }

        public final Builder setLang(String string) {
            this.config.setLang(string);
            return this;
        }

        public final Builder setExpired(int n) {
            this.config.setExpired(n);
            return this;
        }

        public final Builder setUsername(String string) {
            this.config.setUsername(string);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LANG {
    }
}

