package com.qipeng.captcha.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;

import com.qipeng.captcha.QPCaptcha;

import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;

/**
 * OnePiece
 * Created by xukq on 4/29/19.
 */
public class QPUtils {

    /**
     * 将px值转换为dip或dp值，保证尺寸大小不变
     *
     * @param pxValue
     * @param context （DisplayMetrics类中属性density）
     * @return
     */
    public static int px2dip(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }

    /**
     * 将dip或dp值转换为px值，保证尺寸大小不变
     *
     * @param dipValue
     * @param context  （DisplayMetrics类中属性density）
     * @return
     */
    public static int dip2px(Context context, float dipValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    /**
     * 将px值转换为sp值，保证文字大小不变
     *
     * @param pxValue
     * @param context （DisplayMetrics类中属性scaledDensity）
     * @return
     */
    public static int px2sp(Context context, float pxValue) {
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int) (pxValue / fontScale + 0.5f);
    }

    /**
     * 将sp值转换为px值，保证文字大小不变
     *
     * @param spValue
     * @param context （DisplayMetrics类中属性scaledDensity）
     * @return
     */
    public static int sp2px(Context context, float spValue) {
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int) (spValue * fontScale + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static JSONObject getDeviceInfos(Context context) {
        JSONObject deviceInfo = new JSONObject();
        try {
            String appId = SpUtils.getInstance(context).getString(SpUtils.KEY_STRING_APP_ID, "");
            deviceInfo.put("captchaId", appId);
            deviceInfo.put("clientId", SpUtils.getInstance(context).getString(SpUtils.KEY_STRING_CLIENT_ID, ""));
            deviceInfo.put("appVersion", getVersionName(context));
            deviceInfo.put("sdkVersion", QPCaptcha.getInstance().getSDKVersion());
            deviceInfo.put("systemVersion", android.os.Build.VERSION.RELEASE);
            deviceInfo.put("os", "Android");
            deviceInfo.put("packageName", context.getPackageName());
            deviceInfo.put("appName", getApplicationName(context));
            deviceInfo.put("device_brand", android.os.Build.BRAND);
            deviceInfo.put("phoneModel", android.os.Build.BRAND + " " + android.os.Build.MODEL + " " + android.os.Build.DEVICE);
        } catch (Exception e) {

        }
        return deviceInfo;
    }

    public static String getHeaderDeviceInfos(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONObject deviceInfo = getDeviceInfos(context);
            Iterator<String> keys = deviceInfo.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                String value = (String) deviceInfo.get(key);
                if (TextUtils.equals(key, "appName")) {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                stringBuilder.append(key).append("=").append(value).append(";");
            }
        } catch (Exception e) {

        }
        return stringBuilder.toString();
    }

    private static String getVersionName(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    private static String getApplicationName(Context context) {
        String applicationName;
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            applicationName = (String) packageManager.getApplicationLabel(applicationInfo);
        } catch (Exception e) {
            applicationName = "unknown";
        }
        return applicationName;
    }

    private static File getSDKFile(Context context, String fileName) {
        String dirPath = context.getFilesDir() + "/yunpian";
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir + "/" + fileName);
    }

    public static File getSDKJSFile(Context context) {
        return getSDKFile(context, QPCaptcha.JS_NAME);
    }

    public static File getSDKH5File(Context context) {
        return getSDKFile(context, QPCaptcha.H5_NAME);
    }

    public static File getSDKHybridJSFile(Context context) {
        return getSDKFile(context, QPCaptcha.JS_HYBRID_NAME);
    }

    /**
     * 从assets目录中复制文件
     *
     * @param context       Context 使用CopyFiles类的Activity
     * @param pointFileName String  原文件路径  如：/aa
     * @param newPath       String  复制后路径  如：xx:/bb/cc
     */
    public static void copyFilesAssets(Context context, String pointFileName, String newPath) {
        try {
            InputStream is = context.getAssets().open(pointFileName);
            FileOutputStream fos = new FileOutputStream(new File(newPath));
            byte[] buffer = new byte[1024];
            int byteCount = 0;
            while ((byteCount = is.read(buffer)) != -1) {//循环从输入流读取 buffer字节
                fos.write(buffer, 0, byteCount);//将读取的输入流写入到输出流
            }
            fos.flush();//刷新缓冲区
            is.close();
            fos.close();
        } catch (Exception e) {
            e.printStackTrace();
            LogUtils.writeLogToSD(context, "copyFilesAssets", "error = " + e.toString());
        }
    }

    public static String getUA() {
        String userAgentString;
        try {
             userAgentString = "Mozilla/5.0 (Linux; Android "
                    + Build.VERSION.RELEASE + "; "
                    + Build.MODEL + " "
                    + Build.DEVICE + ") "
                    + QPCaptcha.getInstance().getSDKVersion() + " Language/"
                    + Locale.getDefault().getLanguage();
            userAgentString = userAgentString.replaceAll("[^\\x00-\\x7F]", "");
        } catch (Exception ignore) {
            userAgentString = "Mozilla/5.0 (Linux; Android 9; MI 6 Build/PKQ1.190118.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36";
        }
        return userAgentString;
    }

}
