package com.qipeng.captcha.ui;

import android.app.Dialog;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.qipeng.captcha.BuildConfig;
import com.qipeng.captcha.QPCaptchaConfig;
import com.qipeng.captcha.R;
import com.qipeng.captcha.utils.HttpUtils;
import com.qipeng.captcha.utils.LogUtils;
import com.qipeng.captcha.utils.QPUtils;
import com.qipeng.captcha.utils.SpUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;

/**
 * OnePiece
 * DEFAULT 参数都在 QPCaptchaConfig.java 中
 * Created by xukq on 4/28/19.
 */
public class QPCaptchaDialog extends Dialog implements View.OnClickListener {

    private final QPCaptchaConfig config;

    private View loadingView;
    private View captchaView;
    private View closeView;
    private WebView mWebView;

    private int captchaViewWith = -1;

    public QPCaptchaDialog(QPCaptchaConfig config, int themeResId) {
        super(config.getContext(), themeResId);
        this.config = config;
        init();
    }

    private void init() {
        setContentView(R.layout.dialog_captcha);
        loadingView = findViewById(R.id.qp_loading_pb);
        captchaView = findViewById(R.id.qp_captcha_ll);
        mWebView = findViewById(R.id.qp_webview);
        closeView = findViewById(R.id.qp_close_iv);

        findViewById(R.id.qp_root).setOnClickListener(this);
        closeView.setOnClickListener(this);

        WebSettings webSettings = mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);

        // 允许 cookies 设置，否则无法读取
        CookieManager cookieManager = CookieManager.getInstance();
        CookieManager.setAcceptFileSchemeCookies(true);
        cookieManager.setAcceptCookie(true);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            cookieManager.setAcceptThirdPartyCookies(mWebView, true);
        }

        mWebView.setHorizontalScrollBarEnabled(false);
        mWebView.setVerticalScrollBarEnabled(false);
        mWebView.setWebViewClient(new WebViewClient() {
//            @Override
//            public void onPageStarted(WebView view, String url, Bitmap favicon) {
//                super.onPageStarted(view, url, favicon);
//                LogUtils.writeLogToSD(getContext(), "onPageStarted", "url = " + url);
//            }
//
//            @Override
//            public void onPageFinished(WebView view, String url) {
//                super.onPageFinished(view, url);
//                LogUtils.writeLogToSD(getContext(), "onPageFinished", "url = " + url);
//            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    url = request.getUrl().toString();
                } else {
                    url = request.toString();
                }

//                LogUtils.writeLogToSD(getContext(), "shouldOverrideUrlLoading2", "url = " + url);
                // 新系统走这里
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    if (callNativeFunctionByUrl(url)) return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            // 这个回调方法在 Android N 以后废弃了，所以新系统走上面的回调；但是新系统也会走这里的回调，所以里面需要判断
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
//                LogUtils.writeLogToSD(getContext(), "shouldOverrideUrlLoading", "url = " + url);
                // 旧版系统走这里
                if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) {
                    if (callNativeFunctionByUrl(url)) return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
//                handler.proceed();
                LogUtils.writeLogToSD(getContext(), "onReceivedSslError", "error");
                if (config.getCallback() != null) {
                    config.getCallback().onReceivedSslError(view, handler, error);
                }
            }

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                String errorInfo = error == null ? "null error" : error.toString();
                LogUtils.writeLogToSD(getContext(), "onReceivedError", "error = " + errorInfo);
                super.onReceivedError(view, request, error);
            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                String errorInfo = "errorCode = " + errorCode + " description = " + description + " failingUrl = " + failingUrl;
                LogUtils.writeLogToSD(getContext(), "onReceivedError2", "error = " + errorInfo);
                super.onReceivedError(view, errorCode, description, failingUrl);
            }

            @Override
            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                String errorInfo = errorResponse == null ? "null error" : errorResponse.toString();
                LogUtils.writeLogToSD(getContext(), "onReceivedHttpError", "error = " + errorInfo);
                super.onReceivedHttpError(view, request, errorResponse);
            }

            //            @Override
//            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
//                super.onReceivedError(view, request, error);
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//                    if (request.isForMainFrame()) {
//
//                    }
//                } else {
//
//                }
//            }
        });
        File sdkh5File = QPUtils.getSDKH5File(getContext());
        if (sdkh5File.exists()) {
            String h5FilePath = sdkh5File.getAbsolutePath();
            String url = "file://" + h5FilePath;
//            LogUtils.writeLogToSD(getContext(), "QPCaptchaDialog load file html", "");
            mWebView.loadUrl(url);
        } else {
//            LogUtils.writeLogToSD(getContext(), "QPCaptchaDialog load asset html", "");
            mWebView.loadUrl("file:////android_asset/yunpian.html");
        }

        captchaViewWith = config.getWidth();
        captchaView.setAlpha(0);
        closeView.setAlpha(0);
        setCanceledOnTouchOutside(true);
//        ViewGroup.LayoutParams captchaViewLayoutParams = captchaView.getLayoutParams();
//        captchaViewLayoutParams.width = (int) (getContext().getResources().getDisplayMetrics().widthPixels * 0.9f);
//        captchaView.setLayoutParams(pa);
        Window window = getWindow();
        if (window != null) {
            WindowManager.LayoutParams attributes = window.getAttributes();
            attributes.dimAmount = config.getAlpha();
            attributes.width = captchaViewWith;
            window.setAttributes(attributes);
        }
        if (!config.isShowLoadingView()) {
            loadingView.setVisibility(View.GONE);
        }
    }

    private boolean callNativeFunctionByUrl(String url) {
        Uri uri = Uri.parse(url);
        // 如果url的协议 = 预先约定的 js 协议
        // 就解析往下解析参数
        if (TextUtils.equals(uri.getScheme(), "yunpian")) {
            String jsonStr = url.replace("yunpian:", "");
            try {
                JSONObject jsonParam = new JSONObject(jsonStr);
                String functionName = jsonParam.optString("functionName");
                JSONObject argument = jsonParam.optJSONObject("data");
                String callbackId = jsonParam.optString("callbackId");
                callNativeFunction(functionName, argument, callbackId);
            } catch (JSONException e) {
                String msg = "scheme == yunpian url = " + url + " json error";
                if (config.getCallback() != null) {
                    config.getCallback().onError(
                            new CallbackInfo()
                                    .put("msg", msg)
                                    .info());
                }
                uploadErrorInfo("shouldOverrideUrlLoading", msg, LogUtils.LOG_TYPE_ERROR);
                LogUtils.writeLogToSD(getContext(), "shouldOverrideUrlLoading", msg);
            }
            return true;
        } else {
            LogUtils.writeLogToSD(getContext(), "shouldOverrideUrlLoading", "scheme != yunpian url = " + url);
        }
        return false;
    }

    private void sendResponseMessage(JSONObject responseData) {
        String stringBuilder = "javascript:_sendResponseMessage('" + responseData.toString() + "')";
        mWebView.loadUrl(stringBuilder);
    }

    private void callNativeFunction(String funName, JSONObject argument, String callbackId) {
        try {
            JSONObject resultData = new JSONObject();
            resultData.put("responseId", callbackId);
            switch (funName) {
                case "startVerify":
                    JSONObject langPackModel = config.getLangPackModel();
                    JSONObject deviceInfo = QPUtils.getDeviceInfos(getContext());
                    String appId = SpUtils.getInstance(getContext()).getString(SpUtils.KEY_STRING_APP_ID, "");
                    JSONObject responseData = new JSONObject();
                    responseData.put("appId", appId);
                    responseData.put("expired", config.getExpired());
                    responseData.put("winWidth", QPUtils.px2sp(getContext(), captchaViewWith));
                    if (langPackModel != null) {
                        responseData.put("langPack", langPackModel);
                    } else {
                        responseData.put("lang", config.getLang());
                    }
                    responseData.put("nativeInfo", deviceInfo);
                    responseData.put("username", config.getUsername());
                    resultData.put("responseData", responseData);
                    sendResponseMessage(resultData);
//                    LogUtils.writeLogToSD(getContext(), "H5_startVerify", resultData.toString());
                    break;
                case "onSuccess":
                    dismiss();
                    if (config.getCallback() != null) {
                        String msg = argument != null ? argument.toString() : "msg == null";
                        config.getCallback().onSuccess(msg);
                    }
                    break;
                case "onError":
                    dismiss();
                    String errorMsg = argument != null ? argument.toString() : "error reason == null";
                    if (config.getCallback() != null) {
                        config.getCallback().onError(errorMsg);
                    }
                    LogUtils.writeLogToSD(getContext(), "H5_error", errorMsg);
                    break;
                case "onFail":
                    String failMsg = argument != null ? argument.toString() : "error reason == null";
                    if (config.getCallback() != null) {
                        config.getCallback().onFail(failMsg);
                    }
//                    LogUtils.writeLogToSD(getContext(), "H5_fail", failMsg);
                    break;
                case "afterStart":
                    if (config.getCallback() != null) {
                        config.getCallback().onLoaded();
                    }
                    loadingView.setVisibility(View.GONE);
                    closeView.setAlpha(1f);
                    captchaView.setAlpha(1f);
//                    LogUtils.writeLogToSD(getContext(), "H5_afterStart", "");
                    break;
                default:
                    if (BuildConfig.DEBUG) {
                        Toast.makeText(getContext(), "unknown callback", Toast.LENGTH_SHORT).show();
                    }
                    String msg = argument != null ? argument.toString() : "unknown callback " + funName;
                    if (config.getCallback() != null) {
                        config.getCallback().onError(msg);
                    }
                    uploadErrorInfo("H5_default", msg, LogUtils.LOG_TYPE_ERROR);
                    dismiss();
                    LogUtils.writeLogToSD(getContext(), "H5_default", msg);
                    break;
            }
        } catch (Exception e) {
            if (BuildConfig.DEBUG) {
                Toast.makeText(getContext(), "callNativeFunction error", Toast.LENGTH_SHORT).show();
            }
            String msg = argument != null ? argument.toString() : "callNativeFunction error " + e.toString();
            if (config.getCallback() != null) {
                config.getCallback().onError(msg);
            }
            dismiss();
            LogUtils.writeLogToSD(getContext(), "H5_exception", e.toString());
            uploadErrorInfo("H5_exception", msg, LogUtils.LOG_TYPE_ERROR);
        }
    }

    /**
     * 上传错误信息
     *
     * @param errorName
     * @param logContent
     * @param type
     */
    private void uploadErrorInfo(final String errorName, final String logContent, final String type) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                HttpUtils.uploadErrorInfo(getContext(), errorName, logContent, type);
            }
        }).start();
    }

    private class CallbackInfo {

        JSONObject info = new JSONObject();

        public CallbackInfo put(String key, String value) {
            try {
                info.put(key, value);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return this;
        }

        String info() {
            return info.toString();
        }
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.qp_root || id == R.id.qp_close_iv) {
            dismiss();
            if (config.getCallback() != null) {
                config.getCallback().onCancel();
            }
        }
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (mWebView != null) {
            try {
                mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
                // 清除历史记录
                mWebView.clearHistory();
                // 移除WebView
                ((ViewGroup) mWebView.getParent()).removeView(mWebView);
                mWebView.clearCache(true);
                mWebView.freeMemory();
                // 不能销毁，销毁后下次不能继续打开
//                // 销毁VebView
//                mWebView.destroy();
                mWebView = null;
            } catch (Exception ignore) {

            }
        }
    }

}
