/*
 * Decompiled with CFR 0.152.
 */
package com.qipeng.captcha.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.qipeng.captcha.QPCaptcha;
import com.qipeng.captcha.utils.c;
import com.qipeng.captcha.utils.d;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONObject;

public class QPUtils {
    public static int px2dip(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f / f2 + 0.5f);
    }

    public static int dip2px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static int px2sp(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(f / f2 + 0.5f);
    }

    public static int sp2px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(f * f2 + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static JSONObject getDeviceInfos(Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            String string = d.a(context).b("KEY_STRING_APP_ID", "");
            jSONObject.put("captchaId", (Object)string);
            jSONObject.put("clientId", (Object)d.a(context).b("KEY_STRING_CLIENT_ID", ""));
            jSONObject.put("appVersion", (Object)QPUtils.getVersionName(context));
            jSONObject.put("sdkVersion", (Object)QPCaptcha.getInstance().getSDKVersion());
            jSONObject.put("systemVersion", (Object)Build.VERSION.RELEASE);
            jSONObject.put("os", (Object)"Android");
            jSONObject.put("packageName", (Object)context.getPackageName());
            jSONObject.put("appName", (Object)QPUtils.getApplicationName(context));
            jSONObject.put("device_brand", (Object)Build.BRAND);
            jSONObject.put("phoneModel", (Object)(Build.BRAND + " " + Build.MODEL + " " + Build.DEVICE));
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    public static String getHeaderDeviceInfos(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            context = QPUtils.getDeviceInfos(context);
            Iterator iterator = context.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)context.get(string);
                if (TextUtils.equals((CharSequence)string, (CharSequence)"appName")) {
                    string2 = URLEncoder.encode(string2, "UTF-8");
                }
                stringBuilder.append(string).append("=").append(string2).append(";");
            }
        }
        catch (Exception exception) {}
        return stringBuilder.toString();
    }

    private static String getVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "unknown";
        }
    }

    private static String getApplicationName(Context object) {
        try {
            PackageManager packageManager = object.getPackageManager();
            object = packageManager.getApplicationInfo(object.getPackageName(), 0);
            object = (String)packageManager.getApplicationLabel((ApplicationInfo)object);
        }
        catch (Exception exception) {
            object = "unknown";
        }
        return object;
    }

    private static File getSDKFile(Context object, String string) {
        object = object.getFilesDir() + "/yunpian";
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).mkdirs();
        }
        return new File(object + "/" + string);
    }

    public static File getSDKJSFile(Context context) {
        return QPUtils.getSDKFile(context, "riddler-sdk.js");
    }

    public static File getSDKH5File(Context context) {
        return QPUtils.getSDKFile(context, "yunpian.html");
    }

    public static File getSDKHybridJSFile(Context context) {
        return QPUtils.getSDKFile(context, "hybird.js");
    }

    public static void copyFilesAssets(Context context, String object, String object2) {
        try {
            int n;
            object = context.getAssets().open((String)object);
            object2 = new FileOutputStream(new File((String)object2));
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                ((FileOutputStream)object2).write(byArray, 0, n);
            }
            ((OutputStream)object2).flush();
            ((InputStream)object).close();
            ((FileOutputStream)object2).close();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            c.a(context, "copyFilesAssets", "error = " + ((Throwable)object).toString());
            return;
        }
    }

    public static String getUA() {
        String string;
        try {
            string = ("Mozilla/5.0 (Linux; Android " + Build.VERSION.RELEASE + "; " + Build.MODEL + " " + Build.DEVICE + ") " + QPCaptcha.getInstance().getSDKVersion() + " Language/" + Locale.getDefault().getLanguage()).replaceAll("[^\\x00-\\x7F]", "");
        }
        catch (Exception exception) {
            string = "Mozilla/5.0 (Linux; Android 9; MI 6 Build/PKQ1.190118.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/74.0.3729.136 Mobile Safari/537.36";
        }
        return string;
    }
}

