/*
 * Decompiled with CFR 0.152.
 */
package com.qipeng.captcha.ui;

import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.qipeng.captcha.QPCaptchaConfig;
import com.qipeng.captcha.R;
import com.qipeng.captcha.utils.QPUtils;
import com.qipeng.captcha.utils.c;
import com.qipeng.captcha.utils.d;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class QPCaptchaDialog
extends Dialog
implements View.OnClickListener {
    private final QPCaptchaConfig config;
    private View loadingView;
    private View captchaView;
    private View closeView;
    private WebView mWebView;
    private int captchaViewWith = -1;

    public QPCaptchaDialog(QPCaptchaConfig qPCaptchaConfig, int n) {
        super((Context)qPCaptchaConfig.getContext(), n);
        this.config = qPCaptchaConfig;
        this.init();
    }

    private void init() {
        String string;
        this.setContentView(R.layout.dialog_captcha);
        this.loadingView = this.findViewById(R.id.qp_loading_pb);
        this.captchaView = this.findViewById(R.id.qp_captcha_ll);
        this.mWebView = (WebView)this.findViewById(R.id.qp_webview);
        this.closeView = this.findViewById(R.id.qp_close_iv);
        this.findViewById(R.id.qp_root).setOnClickListener((View.OnClickListener)this);
        this.closeView.setOnClickListener((View.OnClickListener)this);
        Object object = this.mWebView.getSettings();
        object.setJavaScriptEnabled(true);
        object.setJavaScriptCanOpenWindowsAutomatically(true);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public final boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
                String string = Build.VERSION.SDK_INT >= 21 ? webResourceRequest.getUrl().toString() : webResourceRequest.toString();
                if (Build.VERSION.SDK_INT >= 24 && QPCaptchaDialog.this.callNativeFunctionByUrl(string)) {
                    return true;
                }
                return super.shouldOverrideUrlLoading(webView, webResourceRequest);
            }

            public final boolean shouldOverrideUrlLoading(WebView webView, String string) {
                if (Build.VERSION.SDK_INT < 24 && QPCaptchaDialog.this.callNativeFunctionByUrl(string)) {
                    return true;
                }
                return super.shouldOverrideUrlLoading(webView, string);
            }

            public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
                sslErrorHandler.proceed();
                c.a(QPCaptchaDialog.this.getContext(), "onReceivedSslError", "error");
            }

            public final void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                String string = webResourceError == null ? "null error" : webResourceError.toString();
                c.a(QPCaptchaDialog.this.getContext(), "onReceivedError", "error = ".concat(String.valueOf(string)));
                super.onReceivedError(webView, webResourceRequest, webResourceError);
            }

            public final void onReceivedError(WebView webView, int n, String string, String string2) {
                String string3 = "errorCode = " + n + " description = " + string + " failingUrl = " + string2;
                c.a(QPCaptchaDialog.this.getContext(), "onReceivedError2", "error = ".concat(String.valueOf(string3)));
                super.onReceivedError(webView, n, string, string2);
            }

            public final void onReceivedHttpError(WebView webView, WebResourceRequest webResourceRequest, WebResourceResponse webResourceResponse) {
                String string = webResourceResponse == null ? "null error" : webResourceResponse.toString();
                c.a(QPCaptchaDialog.this.getContext(), "onReceivedHttpError", "error = ".concat(String.valueOf(string)));
                super.onReceivedHttpError(webView, webResourceRequest, webResourceResponse);
            }
        });
        object = QPUtils.getSDKH5File(this.getContext());
        if (((File)object).exists()) {
            object = ((File)object).getAbsolutePath();
            string = "file://".concat(String.valueOf(object));
            this.mWebView.loadUrl(string);
        } else {
            this.mWebView.loadUrl("file:////android_asset/yunpian.html");
        }
        this.captchaViewWith = this.config.getWidth();
        this.captchaView.setAlpha(0.0f);
        this.closeView.setAlpha(0.0f);
        this.setCanceledOnTouchOutside(true);
        object = this.getWindow();
        if (object != null) {
            string = object.getAttributes();
            object.getAttributes().dimAmount = this.config.getAlpha();
            ((WindowManager.LayoutParams)string).width = this.captchaViewWith;
            object.setAttributes((WindowManager.LayoutParams)string);
        }
        if (!this.config.isShowLoadingView()) {
            this.loadingView.setVisibility(8);
        }
    }

    private boolean callNativeFunctionByUrl(String string) {
        if (TextUtils.equals((CharSequence)Uri.parse((String)string).getScheme(), (CharSequence)"yunpian")) {
            String string2 = string.replace("yunpian:", "");
            try {
                string2 = new JSONObject(string2);
                String string3 = string2.optString("functionName");
                JSONObject jSONObject = string2.optJSONObject("data");
                string2 = string2.optString("callbackId");
                this.callNativeFunction(string3, jSONObject, string2);
            }
            catch (JSONException jSONException) {
                String string4 = "scheme == yunpian url = " + string + " json error";
                if (this.config.getCallback() != null) {
                    this.config.getCallback().onError((QPCaptchaDialog)this.new a((byte)0).a((String)"msg", (String)string4).a.toString());
                }
                this.uploadErrorInfo("shouldOverrideUrlLoading", string4, "error");
                c.a(this.getContext(), "shouldOverrideUrlLoading", string4);
            }
            return true;
        }
        c.a(this.getContext(), "shouldOverrideUrlLoading", "scheme != yunpian url = ".concat(String.valueOf(string)));
        return false;
    }

    private void sendResponseMessage(JSONObject object) {
        object = "javascript:_sendResponseMessage('" + object.toString() + "')";
        this.mWebView.loadUrl((String)object);
    }

    private void callNativeFunction(String string, JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("responseId", (Object)string2);
            switch (string) {
                case "startVerify": {
                    string = this.config.getLangPackModel();
                    string2 = QPUtils.getDeviceInfos(this.getContext());
                    String string3 = d.a(this.getContext()).b("KEY_STRING_APP_ID", "");
                    JSONObject jSONObject3 = new JSONObject();
                    jSONObject3.put("appId", (Object)string3);
                    jSONObject3.put("expired", this.config.getExpired());
                    jSONObject3.put("winWidth", QPUtils.px2sp(this.getContext(), this.captchaViewWith));
                    if (string != null) {
                        jSONObject3.put("langPack", (Object)string);
                    } else {
                        jSONObject3.put("lang", (Object)this.config.getLang());
                    }
                    jSONObject3.put("nativeInfo", (Object)string2);
                    jSONObject2.put("responseData", (Object)jSONObject3);
                    this.sendResponseMessage(jSONObject2);
                    return;
                }
                case "onSuccess": {
                    this.dismiss();
                    if (this.config.getCallback() == null) break;
                    string = jSONObject != null ? jSONObject.toString() : "msg == null";
                    this.config.getCallback().onSuccess(string);
                    return;
                }
                case "onError": {
                    this.dismiss();
                    String string4 = string = jSONObject != null ? jSONObject.toString() : "error reason == null";
                    if (this.config.getCallback() != null) {
                        this.config.getCallback().onError(string);
                    }
                    c.a(this.getContext(), "H5_error", string);
                    return;
                }
                case "onFail": {
                    String string5 = string = jSONObject != null ? jSONObject.toString() : "error reason == null";
                    if (this.config.getCallback() == null) break;
                    this.config.getCallback().onFail(string);
                    return;
                }
                case "afterStart": {
                    if (this.config.getCallback() != null) {
                        this.config.getCallback().onLoaded();
                    }
                    this.loadingView.setVisibility(8);
                    this.closeView.setAlpha(1.0f);
                    this.captchaView.setAlpha(1.0f);
                    return;
                }
                default: {
                    String string6 = string = jSONObject != null ? jSONObject.toString() : "unknown callback ".concat(String.valueOf(string));
                    if (this.config.getCallback() != null) {
                        this.config.getCallback().onError(string);
                    }
                    this.uploadErrorInfo("H5_default", string, "error");
                    this.dismiss();
                    c.a(this.getContext(), "H5_default", string);
                }
            }
            return;
        }
        catch (Exception exception) {
            String string7 = string2 = jSONObject != null ? jSONObject.toString() : "callNativeFunction error " + exception.toString();
            if (this.config.getCallback() != null) {
                this.config.getCallback().onError(string2);
            }
            this.dismiss();
            c.a(this.getContext(), "H5_exception", exception.toString());
            this.uploadErrorInfo("H5_exception", string2, "error");
            return;
        }
    }

    private void uploadErrorInfo(final String string, final String string2, final String string3) {
        new Thread(new Runnable(){

            @Override
            public final void run() {
                com.qipeng.captcha.utils.a.a(QPCaptchaDialog.this.getContext(), string, string2, string3);
            }
        }).start();
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.qp_root || n == R.id.qp_close_iv) {
            this.dismiss();
            if (this.config.getCallback() != null) {
                this.config.getCallback().onCancel();
            }
        }
    }

    public void dismiss() {
        super.dismiss();
        if (this.mWebView != null) {
            try {
                this.mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
                this.mWebView.clearHistory();
                ((ViewGroup)this.mWebView.getParent()).removeView((View)this.mWebView);
                this.mWebView.destroy();
                this.mWebView.clearCache(true);
                this.mWebView.freeMemory();
                this.mWebView.destroy();
                this.mWebView = null;
                return;
            }
            catch (Exception exception) {}
        }
    }

    final class a {
        JSONObject a = new JSONObject();

        private a() {
        }

        public final a a(String string, String string2) {
            try {
                this.a.put(string, (Object)string2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return this;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

