package com.qipeng.captcha.utils;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;

import com.qipeng.captcha.QPCaptcha;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.net.ssl.HttpsURLConnection;

/**
 * OnePiece
 * Created by xukq on 4/28/19.
 */
public class HttpUtils {

    public static Map<String, String> sHeader;
    private static final String BASE_URL = "https://captcha.yunpian.com/";
    private static final String YUNPIAN_URL = "https://www.yunpian.com/";

    private static void parseURLConnection(URLConnection urlConnection) {
        if (sHeader != null) {
            Set<String> keySet = sHeader.keySet();
            Iterator<String> keyIterator = keySet.iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next();
                urlConnection.setRequestProperty(key, sHeader.get(key));
            }
        }
    }

    @WorkerThread
    private static <T> Result<T> get(String url, Map<String, String> params) {
        Result<T> result = new Result<>();
        InputStream stream = null;
        HttpsURLConnection connection = null;
        try {
            URL baseUrl = new URL(url + JsonUtils.iniGetParams(params));
            connection = (HttpsURLConnection) baseUrl.openConnection();
            parseURLConnection(connection);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            result.msg = connection.getResponseMessage();
            result.code = responseCode;
            if (HttpURLConnection.HTTP_OK == responseCode) {
                stream = connection.getInputStream();
                String backcontent = readStream(stream, 500);
                backcontent = URLDecoder.decode(backcontent, "UTF-8");
                result.t = (T) backcontent;
            }
        } catch (Exception e) {
            result.code = -1;
            result.msg = e.getMessage();
        } finally {
            // Close Stream and disconnect HTTPS connection.
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    @WorkerThread
    private static <T> Result<T> post(String url, Map<String, Object> params) {
        JSONObject jsonParams = JsonUtils.mapToJson(params);
        return post(url, jsonParams);
    }

    @WorkerThread
    private static <T> Result<T> post(String url, @NonNull JSONObject params) {
        Result<T> result = new Result<>();
        InputStream stream = null;
        HttpsURLConnection connection = null;
        try {
            URL baseUrl = new URL(BASE_URL + url);
            connection = (HttpsURLConnection) baseUrl.openConnection();
            parseURLConnection(connection);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(5000);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(params.toString().getBytes());
            outputStream.flush();
            outputStream.close();
            stream = connection.getInputStream();
            String resultContent = readStream(stream, 500);
            resultContent = URLDecoder.decode(resultContent, "UTF-8");
            if (HttpURLConnection.HTTP_OK == connection.getResponseCode()) {
                result.code = HttpURLConnection.HTTP_OK;
                result.t = (T) resultContent;
            } else {
                result.code = connection.getResponseCode();
                result.setMsg(resultContent);
            }
        } catch (Exception e) {
            result.code = -1;
            result.msg = e.getMessage();
        } finally {
            // Close Stream and disconnect HTTPS connection.
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return result;
    }

    private static boolean downloadUrl(String downloadUrl, File destFile) {
        HttpsURLConnection connection = null;
        try {
            URL url = new URL(downloadUrl);
            connection = (HttpsURLConnection) url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            // Open communications link (network traffic occurs here).
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (HttpURLConnection.HTTP_OK == responseCode) {
                //创建一个文件输出流
                FileOutputStream outputStream = new FileOutputStream(destFile);
                InputStream inputStream = connection.getInputStream();
                BufferedInputStream bfi = new BufferedInputStream(inputStream);
                int len;
                byte[] bytes = new byte[1024];
                while ((len = bfi.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, len);
                }
                //关闭打开的流对象
                outputStream.close();
                inputStream.close();
                bfi.close();
                return true;
            } else {
                return false;
            }
        } catch (Exception ignored) {

        } finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public static Result<String> init(Context context) {
        JSONObject deviceInfos = QPUtils.getDeviceInfos(context);
        return post("analytics/collect", deviceInfos);
    }

    public static Result<String> uploadErrorInfo(Context context, String errorName, String logContent, String type) {
        JSONObject deviceInfos = QPUtils.getDeviceInfos(context);
        JSONObject logObj = new JSONObject();
        try {
            logObj.put("time", String.valueOf(System.currentTimeMillis()));
            logObj.put("type", type);
            logObj.put("log", logContent);
            logObj.put("name", errorName);
            deviceInfos.put("content", logObj);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return post("analytics/collect", deviceInfos);
    }

    public static void checkVersion(Context context) {
        Result<String> result = get(YUNPIAN_URL + "static/official/js/libs/native/version.json", new HashMap<String, String>());
        if (result.getCode() == 200) {
            try {
                JSONObject versionResultObj = new JSONObject(result.getT());
                JSONObject sdkObj = versionResultObj.optJSONObject("sdk");
                String sdkJSVersion = sdkObj.optString("version");
                String sdkJSMinor = sdkObj.optString("minor");
                String nativeSdkJsVersion = SpUtils.getInstance(context).getString("sdk_js_version", QPCaptcha.SDK_JS_VERSION);
                String nativeSdkJsMinor = SpUtils.getInstance(context).getString("sdk_js_minor", QPCaptcha.SDK_JS_MINOR);
                // 时间不同，就更新
                if (!TextUtils.equals(sdkJSVersion, nativeSdkJsVersion) || !TextUtils.equals(sdkJSMinor, nativeSdkJsMinor)) {
                    String url = sdkObj.optString("url");
                    boolean isSuc = downloadUrl(url, QPUtils.getSDKJSFile(context));
                    // 更新成功就保存版本号
                    if (isSuc) {
                        SpUtils.getInstance(context).putString("sdk_js_version", sdkJSVersion);
                        SpUtils.getInstance(context).putString("sdk_js_minor", sdkJSMinor);
                        QPCaptcha.SDK_JS_VERSION = sdkJSVersion;
                        QPCaptcha.SDK_JS_MINOR = sdkJSMinor;
                        HttpUtils.sHeader.put("x-internal-versions", "h5=" + QPCaptcha.SDK_H5_VERSION + "(" + QPCaptcha.SDK_H5_MINOR + ");" + "js-sdk=" + QPCaptcha.SDK_JS_VERSION + "(" + QPCaptcha.SDK_JS_MINOR + ");");
                    }
                }

                JSONObject h5Obj = versionResultObj.optJSONObject("h5");
                String sdkH5Version = h5Obj.optString("version");
                String sdkH5Minor = h5Obj.optString("minor");
                String nativeSdkH5Version = SpUtils.getInstance(context).getString("sdk_h5_version", QPCaptcha.SDK_H5_VERSION);
                String nativeSdkH5Minor = SpUtils.getInstance(context).getString("sdk_h5_minor", QPCaptcha.SDK_H5_MINOR);
                // 时间不同，就更新
                if (!TextUtils.equals(sdkH5Version, nativeSdkH5Version) || !TextUtils.equals(sdkH5Minor, nativeSdkH5Minor)) {
                    String url = h5Obj.optString("url");
                    boolean isSuc = downloadUrl(url, QPUtils.getSDKH5File(context));
                    // 更新成功就保存版本号
                    if (isSuc) {
                        SpUtils.getInstance(context).putString("sdk_h5_version", sdkH5Version);
                        SpUtils.getInstance(context).putString("sdk_h5_minor", sdkH5Minor);
                        QPCaptcha.SDK_H5_VERSION = sdkH5Version;
                        QPCaptcha.SDK_H5_MINOR = sdkH5Minor;
                        HttpUtils.sHeader.put("x-internal-versions", "h5=" + QPCaptcha.SDK_H5_VERSION + "(" + QPCaptcha.SDK_H5_MINOR + ");" + "js-sdk=" + QPCaptcha.SDK_JS_VERSION + "(" + QPCaptcha.SDK_JS_MINOR + ");");
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            // 写入错误信息到本地
            LogUtils.writeLogToSD(context, "check_version", "code = " + result.getCode() + " msg = " + result.getMsg());
        }
    }

    /**
     * Converts the contents of an InputStream to a String.
     */
    private static String readStream(InputStream stream, int maxReadSize)
            throws IOException {
        Reader reader;
        reader = new InputStreamReader(stream, "UTF-8");
        char[] rawBuffer = new char[maxReadSize];
        int readSize;
        StringBuffer buffer = new StringBuffer();
        while (((readSize = reader.read(rawBuffer)) != -1) && maxReadSize > 0) {
            if (readSize > maxReadSize) {
                readSize = maxReadSize;
            }
            buffer.append(rawBuffer, 0, readSize);
            maxReadSize -= readSize;
        }
        return buffer.toString();
    }

    public static class Result<T> {

        private int code;
        private String msg;
        private T t;

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public T getT() {
            return t;
        }

        public void setT(T t) {
            this.t = t;
        }
    }

}
