package com.qipeng.captcha;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.StringDef;

import com.qipeng.captcha.utils.QPUtils;

import org.json.JSONObject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * OnePiece
 * Created by xukq on 4/28/19.
 */
public class QPCaptchaConfig {

    public static final String LANG_ZH = "zh-cn";
    public static final String LANG_EN = "en";

    @StringDef({LANG_ZH, LANG_EN})
    @Retention(RetentionPolicy.SOURCE)
    public @interface LANG {
    }

    private Activity context;
    private float alpha;
    private boolean isShowLoadingView;
    private QPCaptchaListener callback;
    private JSONObject langPackModel;
    private int width;
    private int expired;
    private String lang;

    private QPCaptchaConfig(Context context) {
        this.width = QPUtils.getScreenWidth(context) - QPUtils.dip2px(context, 32);
        this.alpha = 0.7f;
        this.isShowLoadingView = true;
        this.expired = 30;
        this.lang = LANG_ZH;
    }

    public Activity getContext() {
        return context;
    }

    private void setContext(Activity context) {
        this.context = context;
    }

    public float getAlpha() {
        return alpha;
    }

    private void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean isShowLoadingView() {
        return isShowLoadingView;
    }

    public void setShowLoadingView(boolean showLoadingView) {
        isShowLoadingView = showLoadingView;
    }

    private void showLoadingView(boolean isShowLoadingView) {
        this.isShowLoadingView = isShowLoadingView;
    }

    public QPCaptchaListener getCallback() {
        return callback;
    }

    private void setCallback(QPCaptchaListener callback) {
        this.callback = callback;
    }

    private void setLangPackModel(JSONObject langPackModel) {
        this.langPackModel = langPackModel;
    }

    public JSONObject getLangPackModel() {
        return langPackModel;
    }

    private void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return width;
    }

    private void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return lang;
    }

    private void setExpired(int expired) {
        this.expired = expired;
    }

    public int getExpired() {
        return expired;
    }

    public final static class Builder {

        private QPCaptchaConfig config;

        public Builder(Activity context) {
            config = new QPCaptchaConfig(context);
            config.setContext(context);
        }

        public QPCaptchaConfig build() {
            return config;
        }

        public Builder setCallback(QPCaptchaListener callback) {
            config.setCallback(callback);
            return this;
        }

        public Builder setAlpha(@FloatRange(from = 0, to = 1f) float alpha) {
            config.setAlpha(alpha);
            return this;
        }

        public Builder showLoadingView(boolean isShowLoadingView) {
            config.showLoadingView(isShowLoadingView);
            return this;
        }

        public Builder setLangPackModel(JSONObject langPackModel) {
            config.setLangPackModel(langPackModel);
            return this;
        }

        public Builder setWidth(int width) {
            config.setWidth(width);
            return this;
        }

        public Builder setLang(@LANG String lang) {
            config.setLang(lang);
            return this;
        }

        public Builder setExpired(int expired) {
            config.setExpired(expired);
            return this;
        }

    }

}
