package com.qipeng.captcha.utils;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * OnePiece
 * Created by xukq on 4/30/19.
 */
public class SpUtils {

    public static final String KEY_STRING_APP_ID = "KEY_STRING_APP_ID";
    public static final String KEY_STRING_CLIENT_ID = "KEY_STRING_CLIENT_ID";
    public static final String KEY_LONG_LAST_INIT_TIME = "KEY_LONG_LAST_INIT_TIME";

    private SharedPreferences sp;
    private SharedPreferences.Editor editor;

    private static SpUtils mInstance;

    public static SpUtils getInstance(Context context) {
        if (mInstance == null) {
            synchronized (SpUtils.class) {
                if (mInstance == null) {
                    mInstance = new SpUtils(context);
                }
            }
        }
        return mInstance;
    }

    private SpUtils(Context context) {
        sp = context.getSharedPreferences("qipeng_captcha_sp", Context.MODE_PRIVATE);
    }

    public void putString(String key, String value) {
        editor = sp.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public String getString(String key, String def) {
        return sp.getString(key, def);
    }

    public void putBoolean(String key, boolean value) {
        editor = sp.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public boolean getBoolean(String key, boolean def) {
        return sp.getBoolean(key, def);
    }

    public void putLong(String key, long value) {
        editor = sp.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public long getLong(String key, long def) {
        return sp.getLong(key, def);
    }

}
