/*
 * Decompiled with CFR 0.152.
 */
package com.yun.map;

public class Location {
    private double latitude;
    private double longitude;
    private String city;
    private float direction;
    private long time;
    private float speed;
    private String addrStr;
    private float radius;
    private double gaoDeLatitude;
    private double gaoDeLongitude;

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public String getAddrStr() {
        return this.addrStr;
    }

    public void setAddrStr(String addrStr) {
        this.addrStr = addrStr;
    }

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public double getLongitude() {
        if (this.longitude == 0.0) {
            double[] l = this.gaoDeToBaidu(this.gaoDeLongitude, this.gaoDeLatitude);
            this.latitude = l[0];
            this.longitude = l[1];
        }
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Location(double latitude, double longitude, String city, float direction, long time) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.city = city;
        this.direction = direction;
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public double getLatitude() {
        if (this.latitude == 0.0) {
            double[] l = this.gaoDeToBaidu(this.gaoDeLongitude, this.gaoDeLatitude);
            this.latitude = l[0];
            this.longitude = l[1];
        }
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public float getDirection() {
        return this.direction;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public double getGaoDeLatitude() {
        if (this.gaoDeLatitude == 0.0) {
            double[] l = this.gaoDeToBaidu(this.longitude, this.latitude);
            this.gaoDeLatitude = l[0];
            this.gaoDeLongitude = l[1];
        }
        return this.gaoDeLatitude;
    }

    public void setGaoDeLatitude(double gaoDeLatitude) {
        this.gaoDeLatitude = gaoDeLatitude;
    }

    public double getGaoDeLongitude() {
        if (this.gaoDeLongitude == 0.0) {
            double[] l = this.gaoDeToBaidu(this.longitude, this.latitude);
            this.gaoDeLatitude = l[0];
            this.gaoDeLongitude = l[1];
        }
        return this.gaoDeLongitude;
    }

    public void setGaoDeLongitude(double gaoDeLongitude) {
        this.gaoDeLongitude = gaoDeLongitude;
    }

    private double[] gaoDeToBaidu(double gd_lon, double gd_lat) {
        double[] bd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = gd_lon;
        double y = gd_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * PI);
        bd_lat_lon[0] = z * Math.cos(theta) + 0.0065;
        bd_lat_lon[1] = z * Math.sin(theta) + 0.006;
        return bd_lat_lon;
    }

    private double[] bdToGaoDe(double bd_lat, double bd_lon) {
        double[] gd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * PI);
        gd_lat_lon[0] = z * Math.cos(theta);
        gd_lat_lon[1] = z * Math.sin(theta);
        return gd_lat_lon;
    }
}

