package com.yun.map;

import java.util.List;

/**
 * 地点搜索
 */
public interface ISuggestionSearch {

    /**
     * 设置监听
     *
     * @param iOnGetSuggestionResultListener
     */
    public void setOnGetSuggestionResultListener(IOnGetSuggestionResultListener iOnGetSuggestionResultListener);


    /**
     * 搜索地点
     *
     * @param city
     * @param key
     */
    public void requestSuggestion(String city, String key);


    /**
     * 地点搜索监听
     */
    public interface IOnGetSuggestionResultListener {
        public void onGetSuggestionResult(List<ISuggestionInfo> iSuggestionInfos);
    }

    /**
     * 地点搜索结果
     */
    public interface ISuggestionInfo {
        public String getKey();

        public String getCity();

        public String getDistrict();

        public Location getPt();

        public String getUid();

        public String getTag();

        public String getAddress();

        public List<ISuggestionInfo> poiChildrenInfoList();
    }
}
