package com.yun.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.SpannableString;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

/**
 * 地图抽象接口
 */
public interface IMap {
    /**
     * 创建地图view
     *
     * @param context
     * @param location
     * @param zoom
     * @return
     */
    public View createMapView(Context context, Location location, int zoom);

    /**
     * 生命周期
     */
    public void onResume();

    /**
     * 生命周期
     */
    public void onPause();

    /**
     * 生命周期
     */
    public void onDestroy();


    /**
     * 增加覆盖物
     *
     * @param location
     * @param icon
     */
    public IOverlay addOverlay(Location location, Bitmap icon);


    /**
     * 设置地图上选中的位置
     *
     * @param location
     */
    public void setLocation(Location location);


    /**
     * 设置地图状态监听
     *
     * @param iMapStatusChangeListener
     */
    public void setOnMapStatusChangeListener(IMapStatusChangeListener iMapStatusChangeListener);


    /**
     * 获取路线搜索
     *
     * @return
     */
    public IRoutePlanSearch getRoutePlanSearch(IRoutePlanSearch.IRouteLineStyle iRouteLineStyle);


    /**
     * 获取定位服务
     *
     * @return
     */
    public ILocationService getLocationService();


    /**
     * 绘制路线
     *
     * @param locations
     */
    public void drawRoute(List<Location> locations, IRoutePlanSearch.IRouteLineStyle iRouteLineStyle);


    /**
     * 添加覆盖物
     *
     * @param showInfoWindowDataList
     */
    public void showInfoWindow(List<ShowInfoWindowData> showInfoWindowDataList);


    /**
     * 地图动画
     *
     * @param startLocation
     * @param endLocation
     * @param time
     */
    public void animateMapStatus(Location startLocation, Location endLocation, int time);


    /**
     * 隐藏所有添加的window
     */
    public void hideAllInfoWidow();


    /**
     * 获取屏幕上点的位置
     *
     * @param point
     * @return
     */
    public Location getFromScreenLocation(Point point);


    /**
     * 获取反地理编码
     *
     * @return
     */
    public IGeoCoder getGeoCoder();


    /**
     * 清除所有数据
     */
    public void clearAllData();


    /**
     * 从坐标获取位置
     *
     * @param location
     * @return
     */
    public Point toScreenLocation(Location location);


    /**
     * 绘制路线
     *
     * @param locations
     */
    public void drawTask(List<Location> locations, int color);


    /**
     * 获取两点间的距离
     *
     * @param startLocation
     * @param endLocation
     */
    public double getDistance(Location startLocation, Location endLocation);


    /**
     * 是否显示当前位置
     */
    public void setMyLocationEnabled(boolean isEnable);


    /**
     * 创建view layoutparams
     *
     * @param height
     * @param width
     * @param yOffset
     * @param location
     * @return
     */
    public ViewGroup.LayoutParams createLayoutParams(int height, int width, int yOffset, Location location);

}
